/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.visitor;

import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpressionWithChildren;
import com.apple.foundationdb.record.metadata.expressions.ListKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.query.plan.AvailableFields;
import com.apple.foundationdb.record.query.plan.IndexKeyValueToPartialRecord;
import com.apple.foundationdb.record.query.plan.PlannableIndexTypes;
import com.apple.foundationdb.record.query.plan.RecordQueryPlannerConfiguration;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryCoveringIndexPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlanWithIndex;
import com.apple.foundationdb.record.query.plan.visitor.FilterVisitor;
import com.apple.foundationdb.record.query.plan.visitor.InJoinVisitor;
import com.apple.foundationdb.record.query.plan.visitor.InUnionVisitor;
import com.apple.foundationdb.record.query.plan.visitor.IntersectionVisitor;
import com.apple.foundationdb.record.query.plan.visitor.UnionVisitor;
import com.apple.foundationdb.record.query.plan.visitor.UnorderedPrimaryKeyDistinctVisitor;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class RecordQueryPlannerSubstitutionVisitor {
    @Nonnull
    protected final RecordMetaData recordMetadata;
    @Nonnull
    private final PlannableIndexTypes indexTypes;
    @Nullable
    private final KeyExpression commonPrimaryKey;

    public RecordQueryPlannerSubstitutionVisitor(@Nonnull RecordMetaData recordMetadata, @Nonnull PlannableIndexTypes indexTypes, @Nullable KeyExpression commonPrimaryKey) {
        this.recordMetadata = recordMetadata;
        this.indexTypes = indexTypes;
        this.commonPrimaryKey = commonPrimaryKey;
    }

    public static RecordQueryPlan applyRegularVisitors(@Nonnull RecordQueryPlannerConfiguration configuration, @Nonnull RecordQueryPlan plan, @Nonnull RecordMetaData recordMetaData, @Nonnull PlannableIndexTypes indexTypes, @Nullable KeyExpression commonPrimaryKey) {
        plan = plan.accept(new FilterVisitor(recordMetaData, indexTypes, commonPrimaryKey)).accept(new UnorderedPrimaryKeyDistinctVisitor(recordMetaData, indexTypes, commonPrimaryKey)).accept(new UnionVisitor(recordMetaData, indexTypes, commonPrimaryKey)).accept(new IntersectionVisitor(recordMetaData, indexTypes, commonPrimaryKey));
        if (configuration.shouldDeferFetchAfterInJoinAndInUnion()) {
            plan = plan.accept(new InJoinVisitor(recordMetaData, indexTypes, commonPrimaryKey)).accept(new InUnionVisitor(recordMetaData, indexTypes, commonPrimaryKey));
        }
        return plan.accept(new UnorderedPrimaryKeyDistinctVisitor(recordMetaData, indexTypes, commonPrimaryKey)).accept(new FilterVisitor(recordMetaData, indexTypes, commonPrimaryKey));
    }

    @Nonnull
    public abstract RecordQueryPlan postVisit(@Nonnull RecordQueryPlan var1);

    @Nullable
    public RecordQueryPlan removeIndexFetch(@Nonnull RecordQueryPlan plan, @Nonnull Set<KeyExpression> requiredFields) {
        return RecordQueryPlannerSubstitutionVisitor.removeIndexFetch(this.recordMetadata, this.indexTypes, this.commonPrimaryKey, plan, requiredFields);
    }

    @Nullable
    public static RecordQueryPlan removeIndexFetch(@Nonnull RecordMetaData recordMetaData, @Nonnull PlannableIndexTypes indexTypes, @Nullable KeyExpression commonPrimaryKey, @Nonnull RecordQueryPlan plan, @Nonnull Set<KeyExpression> requiredFields) {
        if (plan instanceof RecordQueryPlanWithIndex) {
            IndexKeyValueToPartialRecord keyValueToPartialRecord;
            RecordQueryPlanWithIndex indexPlan = (RecordQueryPlanWithIndex)plan;
            if (!indexPlan.allowedForCoveringIndexPlan()) {
                return null;
            }
            Index index = recordMetaData.getIndex(indexPlan.getIndexName());
            Collection<RecordType> recordTypes = recordMetaData.recordTypesForIndex(index);
            if (recordTypes.size() != 1) {
                return null;
            }
            RecordType recordType = Iterables.getOnlyElement(recordTypes);
            AvailableFields fieldsFromIndex = AvailableFields.fromIndex(recordType, index, indexTypes, commonPrimaryKey, indexPlan);
            HashSet<KeyExpression> fields = new HashSet<KeyExpression>(requiredFields);
            if (commonPrimaryKey != null) {
                RecordQueryPlannerSubstitutionVisitor.flattenKeys(commonPrimaryKey, fields);
            }
            fields.removeIf(keyExpression -> !keyExpression.needsCopyingToPartialRecord());
            if (fieldsFromIndex.containsAll(fields) && (keyValueToPartialRecord = fieldsFromIndex.buildIndexKeyValueToPartialRecord(recordType).build()) != null) {
                return new RecordQueryCoveringIndexPlan(indexPlan, recordType.getName(), fieldsFromIndex, keyValueToPartialRecord);
            }
        } else if (plan instanceof RecordQueryFetchFromPartialRecordPlan) {
            RecordQueryFetchFromPartialRecordPlan fetchPlan = (RecordQueryFetchFromPartialRecordPlan)plan;
            HashSet<KeyExpression> normalizedRequiredFields = new HashSet<KeyExpression>();
            for (KeyExpression k : requiredFields) {
                normalizedRequiredFields.addAll(k.normalizeKeyForPositions());
            }
            normalizedRequiredFields.remove(Key.Expressions.recordType());
            if (fetchPlan.getChild().getAvailableFields().containsAll(normalizedRequiredFields)) {
                return ((RecordQueryFetchFromPartialRecordPlan)plan).getChild();
            }
        }
        return null;
    }

    private static void flattenKeys(@Nonnull KeyExpression commonPrimaryKey, @Nonnull Set<KeyExpression> fields) {
        if (commonPrimaryKey instanceof ThenKeyExpression || commonPrimaryKey instanceof ListKeyExpression) {
            for (KeyExpression child : ((KeyExpressionWithChildren)commonPrimaryKey).getChildren()) {
                RecordQueryPlannerSubstitutionVisitor.flattenKeys(child, fields);
            }
        } else {
            fields.addAll(commonPrimaryKey.normalizeKeyForPositions());
        }
    }

    @Nullable
    public static RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords resolveFetchIndexRecordsFromPlan(@Nonnull RecordQueryPlan plan) {
        if (plan instanceof RecordQueryPlanWithIndex) {
            return ((RecordQueryPlanWithIndex)plan).getFetchIndexRecords();
        }
        if (plan instanceof RecordQueryFetchFromPartialRecordPlan) {
            return ((RecordQueryFetchFromPartialRecordPlan)plan).getFetchIndexRecords();
        }
        return null;
    }

    @Nonnull
    public AvailableFields availableFields(@Nonnull RecordQueryPlan plan) {
        return RecordQueryPlannerSubstitutionVisitor.availableFields(this.recordMetadata, this.indexTypes, this.commonPrimaryKey, plan);
    }

    @Nonnull
    public static AvailableFields availableFields(@Nonnull RecordMetaData recordMetaData, @Nonnull PlannableIndexTypes indexTypes, @Nullable KeyExpression commonPrimaryKey, @Nonnull RecordQueryPlan plan) {
        if (plan instanceof RecordQueryPlanWithIndex) {
            RecordQueryPlanWithIndex indexPlan = (RecordQueryPlanWithIndex)plan;
            Index index = recordMetaData.getIndex(indexPlan.getIndexName());
            Collection<RecordType> recordTypes = recordMetaData.recordTypesForIndex(index);
            if (recordTypes.size() != 1) {
                return AvailableFields.NO_FIELDS;
            }
            RecordType recordType = Iterables.getOnlyElement(recordTypes);
            return AvailableFields.fromIndex(recordType, index, indexTypes, commonPrimaryKey, indexPlan);
        }
        if (plan instanceof RecordQueryFetchFromPartialRecordPlan) {
            RecordQueryFetchFromPartialRecordPlan fetchPlan = (RecordQueryFetchFromPartialRecordPlan)plan;
            return fetchPlan.getChild().getAvailableFields();
        }
        return AvailableFields.NO_FIELDS;
    }
}

