/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.query.plan.visitor;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.PlannableIndexTypes;
import com.apple.foundationdb.record.query.plan.cascades.Reference;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFilterPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryUnionPlanBase;
import com.apple.foundationdb.record.query.plan.plans.TranslateValueFunction;
import com.apple.foundationdb.record.query.plan.visitor.RecordQueryPlannerSubstitutionVisitor;
import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UnionVisitor
extends RecordQueryPlannerSubstitutionVisitor {
    public UnionVisitor(@Nonnull RecordMetaData recordMetadata, @Nonnull PlannableIndexTypes indexTypes, @Nullable KeyExpression commonPrimaryKey) {
        super(recordMetadata, indexTypes, commonPrimaryKey);
    }

    @Override
    @Nonnull
    public RecordQueryPlan postVisit(@Nonnull RecordQueryPlan recordQueryPlan) {
        if (recordQueryPlan instanceof RecordQueryUnionPlanBase) {
            RecordQueryUnionPlanBase unionPlan = (RecordQueryUnionPlanBase)recordQueryPlan;
            Set<KeyExpression> requiredFields = unionPlan.getRequiredFields();
            boolean shouldPullOutFilter = false;
            QueryComponent filter = null;
            if (unionPlan.getChildren().stream().allMatch(child -> child instanceof RecordQueryFilterPlan)) {
                QueryComponent finalFilter = filter = ((RecordQueryFilterPlan)unionPlan.getChildren().get(0)).getConjunctedFilter();
                shouldPullOutFilter = unionPlan.getChildren().stream().allMatch(plan -> ((RecordQueryFilterPlan)plan).getConjunctedFilter().equals(finalFilter));
            }
            ArrayList<Reference> newChildren = new ArrayList<Reference>(unionPlan.getChildren().size());
            RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords fetchIndexRecords = null;
            Iterator<RecordQueryPlan> iterator = unionPlan.getChildren().iterator();
            while (iterator.hasNext()) {
                RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords currentFetchIndexRecords;
                RecordQueryPlan plan2;
                RecordQueryPlan oldPlan = plan2 = iterator.next();
                if (shouldPullOutFilter) {
                    if (!(oldPlan instanceof RecordQueryFilterPlan)) {
                        throw new RecordCoreException("serious logic error: thought this was a filter plan but it wasn't", new Object[0]);
                    }
                    oldPlan = ((RecordQueryFilterPlan)oldPlan).getChild();
                }
                if ((currentFetchIndexRecords = UnionVisitor.resolveFetchIndexRecordsFromPlan(oldPlan)) == null) {
                    return recordQueryPlan;
                }
                if (fetchIndexRecords == null) {
                    fetchIndexRecords = currentFetchIndexRecords;
                } else if (fetchIndexRecords != currentFetchIndexRecords) {
                    return recordQueryPlan;
                }
                RecordQueryPlan newPlan = this.removeIndexFetch(oldPlan, requiredFields);
                if (newPlan == null) {
                    return recordQueryPlan;
                }
                newChildren.add(Reference.plannedOf(newPlan));
            }
            RecordQueryFetchFromPartialRecordPlan newUnionPlan = new RecordQueryFetchFromPartialRecordPlan(unionPlan.withChildrenReferences(newChildren), TranslateValueFunction.unableToTranslate(), (Type)new Type.Any(), (RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords)Verify.verifyNotNull(fetchIndexRecords));
            if (shouldPullOutFilter) {
                return new RecordQueryFilterPlan((RecordQueryPlan)newUnionPlan, filter);
            }
            return newUnionPlan;
        }
        return recordQueryPlan;
    }
}

