/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.sorting;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.sorting.FileSortAdapter;
import com.apple.foundationdb.record.sorting.FileSortCursorContinuation;
import com.apple.foundationdb.record.sorting.FileSorter;
import com.apple.foundationdb.record.sorting.SortedFileReader;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class FileSortCursor<K, V>
implements RecordCursor<V> {
    @Nonnull
    private final RecordCursor<V> inputCursor;
    @Nonnull
    private final FileSorter<K, V> sorter;
    @Nonnull
    private final FileSortAdapter<K, V> adapter;
    @Nullable
    private final StoreTimer timer;
    private final int skip;
    private final int limit;
    private RecordCursorContinuation inputContinuation;
    private Iterator<Map.Entry<K, V>> inMemoryIterator;
    private int inMemoryPosition;
    @Nullable
    private K minimumKey;
    private SortedFileReader<V> fileReader;
    private boolean closed;

    private FileSortCursor(@Nonnull FileSortAdapter<K, V> adapter, @Nonnull FileSorter<K, V> sorter, @Nonnull RecordCursor<V> inputCursor, @Nullable StoreTimer timer, int skip, int limit) {
        this.inputCursor = inputCursor;
        this.sorter = sorter;
        this.adapter = adapter;
        this.timer = timer;
        this.skip = skip;
        this.limit = limit;
        this.closed = false;
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<V>> onNext() {
        if (this.inMemoryIterator != null) {
            return CompletableFuture.completedFuture(this.nextFromIterator());
        }
        if (this.fileReader != null) {
            return CompletableFuture.completedFuture(this.nextFromReader());
        }
        return this.sorter.load(this.inputCursor).thenApply(loadResult -> {
            this.inputContinuation = loadResult.getSourceContinuation();
            if (loadResult.getSourceNoNextReason().isOutOfBand()) {
                Collection inMemoryRecords = ((NavigableMap)this.sorter.getMapSorter().getMap()).values();
                FileSortCursorContinuation<K, V> continuation = new FileSortCursorContinuation<K, V>(this.adapter, false, true, inMemoryRecords, this.sorter.getFiles(), this.inputContinuation, 0, 0L);
                return RecordCursorResult.withoutNextValue(continuation, loadResult.getSourceNoNextReason());
            }
            if (loadResult.isInMemory()) {
                this.inMemoryIterator = ((NavigableMap)this.sorter.getMapSorter().getMap()).entrySet().iterator();
                for (int i = 0; i < this.skip && this.inMemoryIterator.hasNext(); ++i) {
                    this.inMemoryIterator.next();
                }
                return this.nextFromIterator();
            }
            if (this.sorter.getFiles().size() != 1) {
                throw new RecordCoreException("sort loading did not produce exactly one file", new Object[0]);
            }
            try {
                this.fileReader = new SortedFileReader<V>(this.sorter.getFiles().get(0), this.adapter, this.timer, this.skip, this.limit);
            }
            catch (IOException | GeneralSecurityException ex) {
                throw new RecordCoreException(ex);
            }
            return this.nextFromReader();
        });
    }

    @Nonnull
    private RecordCursorResult<V> nextFromIterator() {
        if (this.inMemoryPosition >= this.limit) {
            FileSortCursorContinuation<K, V> continuation = new FileSortCursorContinuation<K, V>(this.adapter, true, false, Collections.emptyList(), Collections.emptyList(), this.inputContinuation, this.inMemoryPosition, 0L);
            return RecordCursorResult.withoutNextValue(continuation, RecordCursor.NoNextReason.RETURN_LIMIT_REACHED);
        }
        if (this.inMemoryIterator.hasNext()) {
            Map.Entry<K, V> next = this.inMemoryIterator.next();
            this.minimumKey = next.getKey();
            ++this.inMemoryPosition;
            Collection remainingRecords = ((NavigableMap)this.sorter.getMapSorter().getMap()).tailMap(this.minimumKey, false).values();
            FileSortCursorContinuation<K, V> continuation = new FileSortCursorContinuation<K, V>(this.adapter, false, false, remainingRecords, this.sorter.getFiles(), this.inputContinuation, this.inMemoryPosition, 0L);
            return RecordCursorResult.withNextValue(next.getValue(), continuation);
        }
        FileSortCursorContinuation<K, V> continuation = new FileSortCursorContinuation<K, V>(this.adapter, true, false, Collections.emptyList(), Collections.emptyList(), this.inputContinuation, this.inMemoryPosition, 0L);
        return RecordCursorResult.withoutNextValue(continuation, RecordCursor.NoNextReason.SOURCE_EXHAUSTED);
    }

    @Nonnull
    private RecordCursorResult<V> nextFromReader() {
        V record;
        try {
            record = this.fileReader.read();
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new RecordCoreException(ex);
        }
        FileSortCursorContinuation<K, V> continuation = new FileSortCursorContinuation<K, V>(this.adapter, record == null, false, Collections.emptyList(), this.sorter.getFiles(), this.inputContinuation, this.fileReader.getRecordPosition(), this.fileReader.getFilePosition());
        if (record != null) {
            return RecordCursorResult.withNextValue(record, continuation);
        }
        return RecordCursorResult.withoutNextValue(continuation, RecordCursor.NoNextReason.SOURCE_EXHAUSTED);
    }

    @Override
    public void close() {
        this.inputCursor.close();
        try {
            this.sorter.deleteFiles();
        }
        catch (IOException ex) {
            throw new RecordCoreException(ex);
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.inputCursor.getExecutor();
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        if (visitor.visitEnter(this)) {
            this.inputCursor.accept(visitor);
        }
        return visitor.visitLeave(this);
    }

    public static <K, V> FileSortCursor<K, V> create(@Nonnull FileSortAdapter<K, V> adapter, @Nonnull Function<byte[], RecordCursor<V>> inputCursorFunction, @Nullable StoreTimer timer, @Nullable byte[] continuation, int skip, int limit) {
        FileSortCursorContinuation<K, V> parsedContinuation = FileSortCursorContinuation.from(continuation, adapter);
        RecordCursor inputCursor = parsedContinuation.isLoading() ? inputCursorFunction.apply(parsedContinuation.getChild().toBytes()) : RecordCursor.empty();
        FileSorter<K, V> sorter = new FileSorter<K, V>(adapter, timer, inputCursor.getExecutor());
        for (V record : parsedContinuation.getInMemoryRecords()) {
            sorter.getMapSorter().addValue(record);
        }
        for (File file : parsedContinuation.getFiles()) {
            sorter.getFiles().add(file);
        }
        return new FileSortCursor<K, V>(adapter, sorter, inputCursor, timer, skip, limit);
    }
}

