/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.sorting;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ByteArrayContinuation;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorStartContinuation;
import com.apple.foundationdb.record.RecordSortingProto;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.sorting.FileSortAdapter;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ZeroCopyByteString;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
class FileSortCursorContinuation<K, V>
implements RecordCursorContinuation {
    @Nonnull
    private final FileSortAdapter<K, V> adapter;
    private final boolean exhausted;
    private final boolean loading;
    @Nonnull
    private final Collection<V> inMemoryRecords;
    @Nonnull
    private final List<File> files;
    @Nonnull
    private final RecordCursorContinuation childContinuation;
    private final int recordPosition;
    private final long filePosition;
    @Nullable
    private RecordSortingProto.FileSortContinuation cachedProto;
    @Nullable
    private byte[] cachedBytes;

    FileSortCursorContinuation(@Nonnull FileSortAdapter<K, V> adapter, boolean exhausted, boolean loading, @Nonnull Collection<V> inMemoryRecords, @Nonnull List<File> files, @Nonnull RecordCursorContinuation childContinuation, int recordPosition, long filePosition) {
        this.exhausted = exhausted;
        this.loading = loading;
        this.adapter = adapter;
        this.inMemoryRecords = inMemoryRecords;
        this.files = files;
        this.childContinuation = childContinuation;
        this.recordPosition = recordPosition;
        this.filePosition = filePosition;
    }

    @Nonnull
    RecordSortingProto.FileSortContinuation toProto() {
        if (this.cachedProto == null) {
            RecordSortingProto.FileSortContinuation.Builder builder = RecordSortingProto.FileSortContinuation.newBuilder();
            if (this.loading) {
                builder.setLoading(true);
            }
            for (V record : this.inMemoryRecords) {
                builder.addInMemoryRecords(ZeroCopyByteString.wrap(this.adapter.serializeValue(record)));
            }
            for (File file : this.files) {
                builder.addFiles(file.getPath());
            }
            ByteString childBytes = this.childContinuation.toByteString();
            if (childBytes.isEmpty()) {
                builder.setContinuation(childBytes);
            }
            if (this.recordPosition > 0) {
                builder.setRecordPosition(this.recordPosition);
            }
            if (this.filePosition > 0L) {
                builder.setFilePosition(this.filePosition);
            }
            this.cachedProto = builder.build();
        }
        return this.cachedProto;
    }

    @Override
    @Nonnull
    public ByteString toByteString() {
        if (this.isEnd()) {
            return ByteString.EMPTY;
        }
        return this.toProto().toByteString();
    }

    @Override
    @Nullable
    public byte[] toBytes() {
        if (this.isEnd()) {
            return null;
        }
        if (this.cachedBytes == null) {
            this.cachedBytes = this.toByteString().toByteArray();
        }
        return this.cachedBytes;
    }

    @Nonnull
    static <K, V> FileSortCursorContinuation<K, V> from(@Nonnull RecordSortingProto.FileSortContinuation parsed, @Nonnull FileSortAdapter<K, V> adapter) {
        FileSortCursorContinuation<K, V> result = new FileSortCursorContinuation<K, V>(adapter, false, parsed.getLoading(), parsed.getInMemoryRecordsList().stream().map(bs -> adapter.deserializeValue(bs.toByteArray())).collect(Collectors.toList()), parsed.getFilesList().stream().map(File::new).collect(Collectors.toList()), parsed.hasContinuation() ? ByteArrayContinuation.fromNullable(parsed.getContinuation().toByteArray()) : RecordCursorStartContinuation.START, parsed.getRecordPosition(), parsed.getFilePosition());
        result.cachedProto = parsed;
        return result;
    }

    @Nonnull
    static <K, V> FileSortCursorContinuation<K, V> from(@Nullable byte[] unparsed, @Nonnull FileSortAdapter<K, V> adapter) {
        FileSortCursorContinuation<K, V> result;
        if (unparsed == null) {
            result = new FileSortCursorContinuation<K, V>(adapter, false, true, Collections.emptyList(), Collections.emptyList(), RecordCursorStartContinuation.START, 0, 0L);
        } else {
            try {
                result = FileSortCursorContinuation.from(RecordSortingProto.FileSortContinuation.parseFrom(unparsed), adapter);
            }
            catch (InvalidProtocolBufferException ex) {
                throw new RecordCoreException("invalid continuation", ex).addLogInfo(new Object[]{LogMessageKeys.RAW_BYTES, ByteArrayUtil2.loggable(unparsed)});
            }
            result.cachedBytes = unparsed;
        }
        return result;
    }

    public boolean isLoading() {
        return this.loading;
    }

    @Nonnull
    public Collection<V> getInMemoryRecords() {
        return this.inMemoryRecords;
    }

    @Nonnull
    public List<File> getFiles() {
        return this.files;
    }

    @Nonnull
    RecordCursorContinuation getChild() {
        return this.childContinuation;
    }

    public int getRecordPosition() {
        return this.recordPosition;
    }

    public long getFilePosition() {
        return this.filePosition;
    }

    @Override
    public boolean isEnd() {
        return this.exhausted;
    }
}

