/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.sorting;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordSortingProto;
import com.apple.foundationdb.record.provider.common.CipherPool;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.sorting.FileSortAdapter;
import com.apple.foundationdb.record.sorting.MemorySorter;
import com.apple.foundationdb.record.sorting.SortEvents;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.ZeroCopyByteString;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.IvParameterSpec;

@API(value=API.Status.EXPERIMENTAL)
public class FileSorter<K, V> {
    public static final int SORT_FILE_VERSION = 1;
    @Nonnull
    private final MemorySorter<K, V> mapSorter;
    @Nonnull
    private final FileSortAdapter<K, V> adapter;
    @Nullable
    private final StoreTimer timer;
    @Nonnull
    private final Executor executor;
    @Nonnull
    private final List<File> files;
    private LoadResult loadResult;

    public FileSorter(@Nonnull FileSortAdapter<K, V> adapter, @Nullable StoreTimer timer, @Nonnull Executor executor) {
        this.adapter = adapter;
        this.timer = timer;
        this.executor = executor;
        this.mapSorter = new MemorySorter<K, V>(adapter, timer);
        this.files = new ArrayList<File>();
    }

    @Nonnull
    public MemorySorter<K, V> getMapSorter() {
        return this.mapSorter;
    }

    @Nonnull
    public List<File> getFiles() {
        return this.files;
    }

    public CompletableFuture<LoadResult> load(@Nonnull RecordCursor<V> source) {
        this.loadResult = null;
        return AsyncUtil.whileTrue(() -> this.mapSorter.load(source, null).thenCompose(mapResult -> {
            if (mapResult.isFull()) {
                return CompletableFuture.runAsync(() -> this.saveToNextFile(this.adapter.getMaxFileCount()), this.executor).thenApply(vignore -> true);
            }
            if (mapResult.getSourceNoNextReason().isOutOfBand()) {
                this.loadResult = new LoadResult(false, false, mapResult.getSourceContinuation(), mapResult.getSourceNoNextReason());
                return AsyncUtil.READY_FALSE;
            }
            if (this.files.isEmpty() && ((NavigableMap)this.mapSorter.getMap()).size() < this.adapter.getMinFileRecordCount()) {
                this.loadResult = new LoadResult(true, true, mapResult.getSourceContinuation(), mapResult.getSourceNoNextReason());
                return AsyncUtil.READY_FALSE;
            }
            this.loadResult = new LoadResult(true, false, mapResult.getSourceContinuation(), mapResult.getSourceNoNextReason());
            return CompletableFuture.runAsync(() -> this.saveToNextFile(1), this.executor).thenApply(vignore -> false);
        }), this.executor).thenApply(vignore -> this.loadResult);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void saveToNextFile(int maxNumFiles) {
        File file;
        long startTime = System.nanoTime();
        boolean compress = this.adapter.isCompressed();
        Key encryptionKey = this.adapter.getEncryptionKey();
        Cipher cipher = null;
        if (!((NavigableMap)this.mapSorter.getMap()).isEmpty()) {
            block23: {
                try {
                    file = this.adapter.generateFilename();
                    try (FileOutputStream fileStream = new FileOutputStream(file);){
                        CodedOutputStream entryStream;
                        OutputStream outputStream;
                        String cipherName;
                        FileChannel fileChannel = fileStream.getChannel();
                        CodedOutputStream headerStream = CodedOutputStream.newInstance(fileStream);
                        RecordSortingProto.SortFileHeader.Builder fileHeader = RecordSortingProto.SortFileHeader.newBuilder().setVersion(1).setMetaDataVersion(this.adapter.getMetaDataVersion()).setNumberOfRecords(0).setNumberOfSections(0);
                        headerStream.writeMessageNoTag(fileHeader.build());
                        RecordSortingProto.SortSectionHeader.Builder sectionHeader = RecordSortingProto.SortSectionHeader.newBuilder().setNumberOfRecords(0).setNumberOfBytes(0L);
                        if (encryptionKey != null && (cipherName = this.adapter.getEncryptionCipherName()) != null) {
                            cipher = CipherPool.borrowCipher(cipherName);
                            FileSorter.initCipherEncrypt(cipher, encryptionKey, this.adapter.getSecureRandom(), sectionHeader);
                        }
                        headerStream.writeMessageNoTag(sectionHeader.build());
                        long headerEnd = headerStream.getTotalBytesWritten();
                        if (compress || cipher != null) {
                            headerStream.flush();
                            outputStream = FileSorter.wrapOutputStream(fileStream, cipher, compress);
                            entryStream = CodedOutputStream.newInstance(outputStream);
                        } else {
                            outputStream = fileStream;
                            entryStream = headerStream;
                        }
                        if (this.timer != null) {
                            this.timer.recordSinceNanoTime(SortEvents.Events.FILE_SORT_OPEN_FILE, startTime);
                        }
                        int numberOfRecords = 0;
                        for (Map.Entry keyAndValue : ((NavigableMap)this.mapSorter.getMap()).entrySet()) {
                            long recordStartTime = System.nanoTime();
                            entryStream.writeByteArrayNoTag(this.adapter.serializeKey(keyAndValue.getKey()));
                            this.adapter.writeValue(keyAndValue.getValue(), entryStream);
                            ++numberOfRecords;
                            if (this.timer == null) continue;
                            this.timer.recordSinceNanoTime(SortEvents.Events.FILE_SORT_SAVE_RECORD, recordStartTime);
                        }
                        entryStream.flush();
                        if (outputStream != fileStream) {
                            outputStream.close();
                        }
                        long fileLength = fileChannel.position();
                        fileChannel.position(0L);
                        fileHeader.setNumberOfSections(1).setNumberOfRecords(numberOfRecords);
                        headerStream.writeMessageNoTag(fileHeader.build());
                        sectionHeader.setNumberOfRecords(numberOfRecords).setNumberOfBytes(fileLength - headerEnd);
                        headerStream.writeMessageNoTag(sectionHeader.build());
                        headerStream.flush();
                        if (fileChannel.position() != headerEnd) {
                            throw new RecordCoreException("header size changed", new Object[0]);
                        }
                        fileChannel.position(fileLength);
                        if (this.timer != null) {
                            this.timer.increment(SortEvents.Counts.FILE_SORT_FILE_BYTES, (int)fileLength);
                        }
                    }
                    if (cipher == null) break block23;
                }
                catch (IOException | GeneralSecurityException ex) {
                    try {
                        throw new RecordCoreException(ex);
                    }
                    catch (Throwable throwable) {
                        if (cipher != null) {
                            CipherPool.returnCipher(cipher);
                        }
                        throw throwable;
                    }
                }
                CipherPool.returnCipher(cipher);
            }
            this.files.add(file);
            ((NavigableMap)this.mapSorter.getMap()).clear();
        }
        if (this.files.size() > maxNumFiles) {
            try {
                file = this.adapter.generateFilename();
                this.merge(this.files, file);
            }
            catch (IOException | GeneralSecurityException ex) {
                throw new RecordCoreException(ex);
            }
            this.files.clear();
            this.files.add(file);
        }
    }

    static void initCipherEncrypt(@Nonnull Cipher cipher, @Nonnull Key encryptionKey, @Nonnull SecureRandom secureRandom, @Nonnull RecordSortingProto.SortSectionHeader.Builder sectionHeader) throws GeneralSecurityException {
        byte[] iv = new byte[16];
        secureRandom.nextBytes(iv);
        sectionHeader.setEncryptionIv(ZeroCopyByteString.wrap(iv));
        cipher.init(1, encryptionKey, new IvParameterSpec(iv));
    }

    static void initCipherDecrypt(@Nonnull Cipher cipher, @Nonnull Key encryptionKey, @Nonnull RecordSortingProto.SortSectionHeader.Builder sectionHeader) throws GeneralSecurityException {
        byte[] iv = sectionHeader.getEncryptionIv().toByteArray();
        cipher.init(2, encryptionKey, new IvParameterSpec(iv));
    }

    @Nonnull
    static OutputStream wrapOutputStream(@Nonnull FileOutputStream fileStream, @Nullable Cipher cipher, boolean compress) {
        FilterOutputStream stream = new NoCloseFilterStream(fileStream);
        if (compress) {
            stream = new DeflaterOutputStream(stream);
        }
        if (cipher != null) {
            stream = new CipherOutputStream(stream, cipher);
        }
        return stream;
    }

    @Nonnull
    static InputStream wrapInputStream(@Nonnull FileInputStream fileStream, @Nullable Cipher cipher, boolean compressed) {
        InputStream stream = fileStream;
        if (compressed) {
            stream = new InflaterInputStream(stream);
        }
        if (cipher != null) {
            stream = new CipherInputStream(stream, cipher);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void merge(@Nonnull Collection<File> inputFiles, @Nonnull File outputFile) throws IOException, GeneralSecurityException {
        boolean success;
        ArrayList<InputState> inputs;
        long startTime;
        block26: {
            startTime = System.nanoTime();
            inputs = new ArrayList<InputState>(inputFiles.size());
            OutputState output = null;
            success = false;
            try {
                for (File file : inputFiles) {
                    InputState input = new InputState(file, this.adapter);
                    inputs.add(input);
                    input.next();
                }
                output = new OutputState(outputFile, this.adapter);
                while (true) {
                    InputState minState = null;
                    for (InputState input : inputs) {
                        if (input.key == null) continue;
                        if (minState == null) {
                            minState = input;
                            continue;
                        }
                        int comp = this.adapter.isSerializedOrderReversed() ? ByteArrayUtil.compareUnsigned(input.key, minState.key) : ByteArrayUtil.compareUnsigned(minState.key, input.key);
                        if (comp <= 0) continue;
                        minState = input;
                    }
                    if (minState == null) {
                        output.finish();
                        output.close();
                        success = true;
                        if (output == null) break block26;
                        break;
                    }
                    output.next(minState.key, minState.value);
                    minState.next();
                }
            }
            catch (Throwable throwable) {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (!success) {
                        try {
                            this.deleteFile(outputFile);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                Iterator iterator = inputs.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        if (this.timer == null) throw throwable;
                        this.timer.recordSinceNanoTime(SortEvents.Events.FILE_SORT_MERGE_FILES, startTime);
                        throw throwable;
                    }
                    InputState input = (InputState)iterator.next();
                    try {
                        input.close();
                        if (!success) continue;
                        this.deleteFile(input.file);
                    }
                    catch (IOException iOException) {}
                }
            }
            try {
                output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!success) {
                try {
                    this.deleteFile(outputFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        Iterator<File> iterator = inputs.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                if (this.timer == null) return;
                this.timer.recordSinceNanoTime(SortEvents.Events.FILE_SORT_MERGE_FILES, startTime);
                return;
            }
            InputState inputState = (InputState)((Object)iterator.next());
            try {
                inputState.close();
                if (!success) continue;
                this.deleteFile(inputState.file);
            }
            catch (IOException iOException) {
            }
        }
    }

    public void deleteFiles() throws IOException {
        for (File file : this.files) {
            this.deleteFile(file);
        }
    }

    private void deleteFile(@Nonnull File file) throws IOException {
        Files.delete(file.toPath());
    }

    public static class LoadResult {
        private final boolean loadComplete;
        private final boolean inMemory;
        @Nonnull
        private final RecordCursorContinuation sourceContinuation;
        @Nonnull
        private final RecordCursor.NoNextReason sourceNoNextReason;

        public LoadResult(boolean loadComplete, boolean inMemory, @Nonnull RecordCursorContinuation sourceContinuation, @Nonnull RecordCursor.NoNextReason sourceNoNextReason) {
            this.loadComplete = loadComplete;
            this.inMemory = inMemory;
            this.sourceContinuation = sourceContinuation;
            this.sourceNoNextReason = sourceNoNextReason;
        }

        public boolean isLoadComplete() {
            return this.loadComplete;
        }

        public boolean isInMemory() {
            return this.inMemory;
        }

        @Nonnull
        public RecordCursorContinuation getSourceContinuation() {
            return this.sourceContinuation;
        }

        @Nonnull
        public RecordCursor.NoNextReason getSourceNoNextReason() {
            return this.sourceNoNextReason;
        }
    }

    private static class NoCloseFilterStream
    extends FilterOutputStream {
        public NoCloseFilterStream(@Nonnull OutputStream stream) {
            super(stream);
        }

        @Override
        public void close() {
        }
    }

    private static class InputState
    implements Closeable {
        @Nonnull
        final File file;
        @Nonnull
        final FileInputStream fileStream;
        @Nonnull
        CodedInputStream headerStream;
        @Nonnull
        CodedInputStream entryStream;
        final boolean compressed;
        @Nullable
        final Key encryptionKey;
        @Nullable
        final Cipher cipher;
        @Nullable
        byte[] key;
        @Nullable
        byte[] value;
        long sectionFilePosition;
        int sectionRecordEnd;
        int fileRecordEnd;
        int recordPosition;

        public InputState(@Nonnull File file, @Nonnull FileSortAdapter<?, ?> adapter) throws IOException, GeneralSecurityException {
            this.file = file;
            this.fileStream = new FileInputStream(file);
            this.entryStream = this.headerStream = CodedInputStream.newInstance(this.fileStream);
            this.compressed = adapter.isCompressed();
            this.encryptionKey = adapter.getEncryptionKey();
            String cipherName = adapter.getEncryptionCipherName();
            this.cipher = this.encryptionKey != null && cipherName != null ? CipherPool.borrowCipher(cipherName) : null;
            RecordSortingProto.SortFileHeader.Builder builder = RecordSortingProto.SortFileHeader.newBuilder();
            this.headerStream.readMessage(builder, ExtensionRegistryLite.getEmptyRegistry());
            if (builder.getVersion() != 1) {
                throw new RecordCoreException("file header version mismatch", new Object[0]);
            }
            if (builder.getMetaDataVersion() != adapter.getMetaDataVersion()) {
                throw new RecordCoreException("file meta-data version mismatch", new Object[0]);
            }
            this.fileRecordEnd = builder.getNumberOfRecords();
        }

        public void next() throws IOException, GeneralSecurityException {
            while (this.recordPosition >= this.sectionRecordEnd) {
                FileChannel fileChannel;
                if (this.recordPosition >= this.fileRecordEnd) {
                    this.key = null;
                    this.value = null;
                    return;
                }
                if (this.compressed || this.encryptionKey != null) {
                    fileChannel = this.fileStream.getChannel();
                    if (this.recordPosition > 0) {
                        fileChannel.position(this.sectionFilePosition);
                        this.headerStream = CodedInputStream.newInstance(this.fileStream);
                    }
                } else {
                    fileChannel = null;
                }
                RecordSortingProto.SortSectionHeader.Builder builder = RecordSortingProto.SortSectionHeader.newBuilder();
                this.headerStream.readMessage(builder, ExtensionRegistryLite.getEmptyRegistry());
                this.sectionRecordEnd += builder.getNumberOfRecords();
                if (fileChannel == null) continue;
                this.sectionFilePosition += (long)this.headerStream.getTotalBytesRead();
                fileChannel.position(this.sectionFilePosition);
                this.sectionFilePosition += builder.getNumberOfBytes();
                if (this.cipher != null) {
                    FileSorter.initCipherDecrypt(this.cipher, this.encryptionKey, builder);
                }
                InputStream inputStream = FileSorter.wrapInputStream(this.fileStream, this.cipher, this.compressed);
                this.entryStream = CodedInputStream.newInstance(inputStream);
            }
            this.key = this.entryStream.readByteArray();
            this.value = this.entryStream.readByteArray();
            ++this.recordPosition;
        }

        @Override
        public void close() throws IOException {
            if (this.cipher != null) {
                CipherPool.returnCipher(this.cipher);
            }
            this.fileStream.close();
        }
    }

    private static class OutputState
    implements Closeable {
        @Nonnull
        final File file;
        final int recordsPerSection;
        @Nonnull
        final FileOutputStream fileStream;
        @Nonnull
        final FileChannel fileChannel;
        @Nonnull
        CodedOutputStream headerStream;
        @Nonnull
        OutputStream outputStream;
        @Nonnull
        CodedOutputStream entryStream;
        final boolean compress;
        @Nullable
        final Key encryptionKey;
        @Nullable
        final SecureRandom secureRandom;
        @Nullable
        final Cipher cipher;
        @Nonnull
        final RecordSortingProto.SortFileHeader.Builder fileHeader;
        @Nonnull
        final RecordSortingProto.SortSectionHeader.Builder sectionHeader;
        long fileHeaderEnd;
        long sectionHeaderPosition;
        long sectionRecordsPosition;

        public OutputState(@Nonnull File file, @Nonnull FileSortAdapter<?, ?> adapter) throws IOException, GeneralSecurityException {
            this.file = file;
            this.recordsPerSection = adapter.getRecordCountPerSection();
            this.fileStream = new FileOutputStream(file);
            this.outputStream = this.fileStream;
            this.fileChannel = this.fileStream.getChannel();
            this.entryStream = this.headerStream = CodedOutputStream.newInstance(this.fileStream);
            this.compress = adapter.isCompressed();
            this.encryptionKey = adapter.getEncryptionKey();
            String cipherName = adapter.getEncryptionCipherName();
            if (this.encryptionKey != null && cipherName != null) {
                this.secureRandom = adapter.getSecureRandom();
                this.cipher = CipherPool.borrowCipher(cipherName);
            } else {
                this.secureRandom = null;
                this.cipher = null;
            }
            this.fileHeader = RecordSortingProto.SortFileHeader.newBuilder().setVersion(1).setMetaDataVersion(adapter.getMetaDataVersion()).setNumberOfSections(0).setNumberOfRecords(0);
            this.headerStream.writeMessageNoTag(this.fileHeader.build());
            this.fileHeaderEnd = this.headerStream.getTotalBytesWritten();
            this.sectionHeader = RecordSortingProto.SortSectionHeader.newBuilder().setSectionNumber(0).setStartRecordNumber(0).setNumberOfRecords(0).setNumberOfBytes(0L);
            this.writeSectionHeader();
        }

        public void next(@Nonnull byte[] key, @Nonnull byte[] value) throws IOException, GeneralSecurityException {
            this.entryStream.writeByteArrayNoTag(key);
            this.entryStream.writeByteArrayNoTag(value);
            this.fileHeader.setNumberOfRecords(this.fileHeader.getNumberOfRecords() + 1);
            this.sectionHeader.setNumberOfRecords(this.sectionHeader.getNumberOfRecords() + 1);
            if (this.sectionHeader.getNumberOfRecords() >= this.recordsPerSection) {
                this.rewriteSectionHeader();
                this.fileHeader.setNumberOfSections(this.fileHeader.getNumberOfSections() + 1);
                this.sectionHeader.setSectionNumber(this.fileHeader.getNumberOfSections());
                this.sectionHeader.setStartRecordNumber(this.fileHeader.getNumberOfRecords());
                this.sectionHeader.setNumberOfRecords(0).setNumberOfBytes(0L);
                this.writeSectionHeader();
            }
        }

        public void finish() throws IOException {
            this.rewriteSectionHeader();
            long fileLength = this.fileChannel.position();
            this.fileChannel.position(0L);
            this.headerStream.writeMessageNoTag(this.fileHeader.build());
            this.headerStream.flush();
            if (this.fileChannel.position() != this.fileHeaderEnd) {
                throw new RecordCoreException("header size changed", new Object[0]);
            }
            this.fileChannel.position(fileLength);
        }

        @Override
        public void close() throws IOException {
            if (this.cipher != null) {
                CipherPool.returnCipher(this.cipher);
            }
            this.fileStream.close();
        }

        void writeSectionHeader() throws IOException, GeneralSecurityException {
            this.headerStream.flush();
            this.sectionHeaderPosition = this.fileChannel.position();
            if (this.cipher != null) {
                FileSorter.initCipherEncrypt(this.cipher, this.encryptionKey, this.secureRandom, this.sectionHeader);
            }
            this.headerStream.writeMessageNoTag(this.sectionHeader.build());
            this.headerStream.flush();
            this.sectionRecordsPosition = this.fileChannel.position();
            if (this.compress || this.cipher != null) {
                this.headerStream.flush();
                this.outputStream = FileSorter.wrapOutputStream(this.fileStream, this.cipher, this.compress);
                this.entryStream = CodedOutputStream.newInstance(this.outputStream);
            }
        }

        void rewriteSectionHeader() throws IOException {
            this.entryStream.flush();
            if (this.outputStream != this.fileStream) {
                this.outputStream.close();
            }
            long fileLength = this.fileChannel.position();
            this.fileChannel.position(this.sectionHeaderPosition);
            this.headerStream.writeMessageNoTag(this.sectionHeader.setNumberOfBytes(fileLength - this.sectionRecordsPosition).build());
            this.headerStream.flush();
            if (this.fileChannel.position() != this.sectionRecordsPosition) {
                throw new RecordCoreException("header size changed", new Object[0]);
            }
            this.fileChannel.position(fileLength);
        }
    }
}

