/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.sorting;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.sorting.MemoryScratchpad;
import com.apple.foundationdb.record.sorting.MemorySortAdapter;
import com.google.common.base.Suppliers;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class MemoryDam<K, V>
extends MemoryScratchpad<K, V, Map<K, V>> {
    public MemoryDam(@Nonnull MemorySortAdapter<K, V> adapter, @Nullable StoreTimer timer) {
        super(adapter, new LinkedHashMap(), timer);
    }

    @Override
    public void removeLast(@Nonnull K currentKey) {
        this.getMap().remove(currentKey);
    }

    @Override
    @Nonnull
    public Collection<V> tailValues(final @Nullable K minimumKey) {
        return new AbstractCollection<V>(){
            private final Supplier<Set<V>> filteredEntriesSupplier = Suppliers.memoize(() -> MemoryDam.filteredEntries(MemoryDam.this.getMap(), minimumKey));

            @Override
            public Iterator<V> iterator() {
                return this.filteredEntriesSupplier.get().iterator();
            }

            @Override
            public int size() {
                return this.filteredEntriesSupplier.get().size();
            }
        };
    }

    private static <K, V, M extends Map<K, V>> Set<V> filteredEntries(@Nonnull M map, @Nullable K minimumKey) {
        LinkedHashSet<V> filteredEntries = new LinkedHashSet<V>();
        boolean hasSeenMinimumKey = false;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (hasSeenMinimumKey) {
                filteredEntries.add(entry.getValue());
                continue;
            }
            if (minimumKey != null && !entry.getKey().equals(minimumKey)) continue;
            hasSeenMinimumKey = true;
        }
        return filteredEntries;
    }
}

