/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.sorting;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.sorting.MemorySortAdapter;
import com.apple.foundationdb.record.sorting.SortEvents;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public abstract class MemoryScratchpad<K, V, M extends Map<K, V>> {
    @Nonnull
    private final M map;
    @Nonnull
    private final MemorySortAdapter<K, V> adapter;
    @Nullable
    private final StoreTimer timer;
    private LoadResult<K> loadResult;

    protected MemoryScratchpad(@Nonnull MemorySortAdapter<K, V> adapter, @Nonnull M map, @Nullable StoreTimer timer) {
        this.adapter = adapter;
        this.map = map;
        this.timer = timer;
    }

    @Nonnull
    public M getMap() {
        return this.map;
    }

    @Nonnull
    public MemorySortAdapter<K, V> getAdapter() {
        return this.adapter;
    }

    public void addKeyValue(K key, V value) {
        this.map.put(key, value);
    }

    public void addValue(V value) {
        this.addKeyValue(this.adapter.generateKey(value), value);
    }

    public CompletableFuture<LoadResult<K>> load(@Nonnull RecordCursor<V> source, @Nullable K minimumKey) {
        this.loadResult = null;
        MemorySortAdapter.MemorySortComparator<K> comparator = this.adapter.getComparator(minimumKey);
        return AsyncUtil.whileTrue(() -> source.onNext().thenApply(sourceResult -> {
            if (!sourceResult.hasNext()) {
                this.loadResult = new LoadResult(false, comparator.nextMinimumKey(), sourceResult.getContinuation(), sourceResult.getNoNextReason());
                return false;
            }
            long startTime = System.nanoTime();
            try {
                Object value = sourceResult.get();
                K key = this.adapter.generateKey(value);
                if (comparator.compareToMinimumKey(key) > 0) {
                    this.addKeyValue(key, value);
                }
                if (this.map.size() <= this.adapter.getMaxRecordCountInMemory()) {
                    Boolean bl = true;
                    return bl;
                }
                switch (this.adapter.getRecordCountInMemoryLimitMode()) {
                    case DISCARD: {
                        this.removeLast(key);
                        Boolean bl = true;
                        return bl;
                    }
                    case STOP: {
                        this.loadResult = new LoadResult(true, comparator.nextMinimumKey(), sourceResult.getContinuation(), RecordCursor.NoNextReason.SCAN_LIMIT_REACHED);
                        Boolean bl = false;
                        return bl;
                    }
                }
                throw new RecordCoreArgumentException("Unknown size limit mode: " + String.valueOf((Object)this.adapter.getRecordCountInMemoryLimitMode()), new Object[0]);
            }
            finally {
                if (this.timer != null) {
                    this.timer.recordSinceNanoTime(SortEvents.Events.MEMORY_SORT_STORE_RECORD, startTime);
                }
            }
        }), source.getExecutor()).thenApply(vignore -> this.loadResult);
    }

    public abstract void removeLast(@Nonnull K var1);

    @Nonnull
    public abstract Collection<V> tailValues(@Nullable K var1);

    public static class LoadResult<K> {
        private final boolean full;
        @Nullable
        private final K nextMinimumKey;
        @Nonnull
        private final RecordCursorContinuation sourceContinuation;
        @Nonnull
        private final RecordCursor.NoNextReason sourceNoNextReason;

        public LoadResult(boolean full, @Nullable K nextMinimumKey, @Nonnull RecordCursorContinuation sourceContinuation, @Nonnull RecordCursor.NoNextReason sourceNoNextReason) {
            this.full = full;
            this.nextMinimumKey = nextMinimumKey;
            this.sourceContinuation = sourceContinuation;
            this.sourceNoNextReason = sourceNoNextReason;
        }

        public boolean isFull() {
            return this.full;
        }

        @Nullable
        public K getNextMinimumKey() {
            return this.nextMinimumKey;
        }

        @Nonnull
        public RecordCursorContinuation getSourceContinuation() {
            return this.sourceContinuation;
        }

        @Nonnull
        public RecordCursor.NoNextReason getSourceNoNextReason() {
            return this.sourceNoNextReason;
        }
    }

    public static enum RecordCountInMemoryLimitMode {
        DISCARD,
        STOP;

    }
}

