/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.sorting;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.sorting.MemoryScratchpad;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public interface MemorySortAdapter<K, V>
extends Comparator<K> {
    @Nonnull
    public K generateKey(V var1);

    @Nonnull
    public byte[] serializeKey(K var1);

    public boolean isSerializedOrderReversed();

    @Nonnull
    public K deserializeKey(@Nonnull byte[] var1);

    @Nonnull
    public byte[] serializeValue(V var1);

    @Nonnull
    public V deserializeValue(@Nonnull byte[] var1);

    public int getMaxRecordCountInMemory();

    @Nonnull
    public MemoryScratchpad.RecordCountInMemoryLimitMode getRecordCountInMemoryLimitMode();

    @Nonnull
    public MemorySortComparator<K> getComparator(@Nullable K var1);

    public static class InsertionOrderComparator<K>
    implements MemorySortComparator<K> {
        @Nonnull
        final Comparator<K> comparator;
        @Nullable
        final K minimumKey;
        boolean hasSeenMinimumKey;

        public InsertionOrderComparator(@Nonnull Comparator<K> comparator, @Nullable K minimumKey) {
            this.comparator = comparator;
            this.minimumKey = minimumKey;
            this.hasSeenMinimumKey = false;
        }

        @Override
        public int compareToMinimumKey(@Nonnull K key) {
            if (this.minimumKey == null) {
                return 1;
            }
            int result = this.comparator.compare(key, this.minimumKey);
            if (result == 0) {
                this.hasSeenMinimumKey = true;
                return -1;
            }
            return this.hasSeenMinimumKey ? 1 : -1;
        }

        @Override
        @Nullable
        public K nextMinimumKey() {
            return this.hasSeenMinimumKey ? null : (K)this.minimumKey;
        }

        @Override
        public int compare(@Nonnull K o1, @Nonnull K o2) {
            throw new RecordCoreException("insertion order does not rely on a Comparator", new Object[0]);
        }
    }

    public static class OrderComparator<K>
    implements MemorySortComparator<K> {
        @Nonnull
        final Comparator<K> comparator;
        @Nullable
        final K minimumKey;

        public OrderComparator(@Nonnull Comparator<K> comparator, @Nullable K minimumKey) {
            this.comparator = comparator;
            this.minimumKey = minimumKey;
        }

        @Override
        public int compareToMinimumKey(@Nonnull K key) {
            if (this.minimumKey == null) {
                return 1;
            }
            return this.comparator.compare(key, this.minimumKey);
        }

        @Override
        @Nullable
        public K nextMinimumKey() {
            return this.minimumKey;
        }

        @Override
        public int compare(@Nonnull K o1, @Nonnull K o2) {
            return this.comparator.compare(o1, o2);
        }
    }

    public static interface MemorySortComparator<K>
    extends Comparator<K> {
        public int compareToMinimumKey(@Nonnull K var1);

        @Nullable
        public K nextMinimumKey();
    }
}

