/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.sorting;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordCursorVisitor;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.sorting.MemoryDam;
import com.apple.foundationdb.record.sorting.MemoryScratchpad;
import com.apple.foundationdb.record.sorting.MemorySortAdapter;
import com.apple.foundationdb.record.sorting.MemorySortCursorContinuation;
import com.apple.foundationdb.record.sorting.MemorySorter;
import com.apple.foundationdb.record.sorting.SortEvents;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class MemorySortCursor<K, V>
implements RecordCursor<V> {
    @Nonnull
    private final RecordCursor<V> inputCursor;
    @Nonnull
    private final MemoryScratchpad<K, V, ? extends Map<K, V>> scratchpad;
    @Nonnull
    private final MemorySortAdapter<K, V> adapter;
    @Nullable
    private final StoreTimer timer;
    @Nullable
    private K minimumKey;
    private RecordCursorContinuation inputContinuation;
    private Iterator<Map.Entry<K, V>> iterator;

    private MemorySortCursor(@Nonnull MemorySortAdapter<K, V> adapter, @Nonnull MemoryScratchpad<K, V, ? extends Map<K, V>> scratchpad, @Nonnull RecordCursor<V> inputCursor, @Nullable StoreTimer timer, @Nullable K minimumKey) {
        this.inputCursor = inputCursor;
        this.scratchpad = scratchpad;
        this.adapter = adapter;
        this.timer = timer;
        this.minimumKey = minimumKey;
    }

    @Override
    @Nonnull
    public CompletableFuture<RecordCursorResult<V>> onNext() {
        if (this.iterator != null) {
            return CompletableFuture.completedFuture(this.nextFromIterator());
        }
        return this.scratchpad.load(this.inputCursor, this.minimumKey).thenApply(loadResult -> {
            this.inputContinuation = loadResult.getSourceContinuation();
            if (loadResult.getSourceNoNextReason().isOutOfBand()) {
                MemorySortCursorContinuation<K, V> continuation = new MemorySortCursorContinuation<K, V>(this.adapter, false, this.scratchpad.getMap().values(), loadResult.getNextMinimumKey(), this.inputContinuation);
                return RecordCursorResult.withoutNextValue(continuation, loadResult.getSourceNoNextReason());
            }
            this.iterator = this.scratchpad.getMap().entrySet().iterator();
            return this.nextFromIterator();
        });
    }

    @Nonnull
    private RecordCursorResult<V> nextFromIterator() {
        long startTime = System.nanoTime();
        if (this.iterator.hasNext()) {
            Map.Entry<K, V> next = this.iterator.next();
            this.minimumKey = next.getKey();
            Collection<V> remainingRecords = this.scratchpad.tailValues(this.minimumKey);
            MemorySortCursorContinuation<K, V> continuation = new MemorySortCursorContinuation<K, V>(this.adapter, false, remainingRecords, this.minimumKey, this.inputContinuation);
            RecordCursorResult<V> result = RecordCursorResult.withNextValue(next.getValue(), continuation);
            if (this.timer != null) {
                this.timer.recordSinceNanoTime(SortEvents.Events.MEMORY_SORT_LOAD_RECORD, startTime);
            }
            return result;
        }
        boolean exhausted = this.scratchpad.getMap().size() < this.adapter.getMaxRecordCountInMemory();
        MemorySortCursorContinuation<K, V> continuation = new MemorySortCursorContinuation<K, V>(this.adapter, exhausted, Collections.emptyList(), this.minimumKey, this.inputContinuation);
        return RecordCursorResult.withoutNextValue(continuation, exhausted ? RecordCursor.NoNextReason.SOURCE_EXHAUSTED : RecordCursor.NoNextReason.RETURN_LIMIT_REACHED);
    }

    @Override
    public void close() {
        this.inputCursor.close();
    }

    @Override
    public boolean isClosed() {
        return this.inputCursor.isClosed();
    }

    @Override
    @Nonnull
    public Executor getExecutor() {
        return this.inputCursor.getExecutor();
    }

    @Override
    public boolean accept(@Nonnull RecordCursorVisitor visitor) {
        if (visitor.visitEnter(this)) {
            this.inputCursor.accept(visitor);
        }
        return visitor.visitLeave(this);
    }

    public static <K, V, M extends Map<K, V>> MemorySortCursor<K, V> create(@Nonnull MemorySortAdapter<K, V> adapter, @Nonnull Function<byte[], RecordCursor<V>> inputCursorFunction, @Nullable StoreTimer timer, @Nonnull BiFunction<MemorySortAdapter<K, V>, StoreTimer, MemoryScratchpad<K, V, M>> scratchPadCreator, @Nullable byte[] continuation) {
        MemorySortCursorContinuation<K, V> parsedContinuation = MemorySortCursorContinuation.from(continuation, adapter);
        RecordCursor<V> inputCursor = inputCursorFunction.apply(parsedContinuation.getChild().toBytes());
        MemoryScratchpad<K, V, M> scratchpad = scratchPadCreator.apply(adapter, timer);
        for (V record : parsedContinuation.getRecords()) {
            scratchpad.addValue(record);
        }
        K minimumKey = parsedContinuation.getMinimumKey();
        return new MemorySortCursor<K, V>(adapter, scratchpad, inputCursor, timer, minimumKey);
    }

    public static <K, V> MemorySortCursor<K, V> createSort(@Nonnull MemorySortAdapter<K, V> adapter, @Nonnull Function<byte[], RecordCursor<V>> inputCursorFunction, @Nullable StoreTimer timer, @Nullable byte[] continuation) {
        return MemorySortCursor.create(adapter, inputCursorFunction, timer, MemorySorter::new, continuation);
    }

    public static <K, V> MemorySortCursor<K, V> createDam(@Nonnull MemorySortAdapter<K, V> adapter, @Nonnull Function<byte[], RecordCursor<V>> inputCursorFunction, @Nullable StoreTimer timer, @Nullable byte[] continuation) {
        return MemorySortCursor.create(adapter, inputCursorFunction, timer, MemoryDam::new, continuation);
    }
}

