/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.sorting;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.ByteArrayContinuation;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursorContinuation;
import com.apple.foundationdb.record.RecordCursorStartContinuation;
import com.apple.foundationdb.record.RecordSortingProto;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.sorting.MemorySortAdapter;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.ZeroCopyByteString;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
class MemorySortCursorContinuation<K, V>
implements RecordCursorContinuation {
    @Nonnull
    private final MemorySortAdapter<K, V> adapter;
    private final boolean exhausted;
    @Nonnull
    private final Collection<V> records;
    @Nullable
    private final K minimumKey;
    @Nonnull
    private final RecordCursorContinuation childContinuation;
    @Nullable
    private RecordSortingProto.MemorySortContinuation cachedProto;
    @Nullable
    private byte[] cachedBytes;

    MemorySortCursorContinuation(@Nonnull MemorySortAdapter<K, V> adapter, boolean exhausted, @Nonnull Collection<V> records, @Nullable K minimumKey, @Nonnull RecordCursorContinuation childContinuation) {
        this.adapter = adapter;
        this.exhausted = exhausted;
        this.records = records;
        this.minimumKey = minimumKey;
        this.childContinuation = childContinuation;
    }

    @Nonnull
    RecordSortingProto.MemorySortContinuation toProto() {
        if (this.cachedProto == null) {
            ByteString childBytes;
            RecordSortingProto.MemorySortContinuation.Builder builder = RecordSortingProto.MemorySortContinuation.newBuilder();
            for (V record : this.records) {
                builder.addRecords(ZeroCopyByteString.wrap(this.adapter.serializeValue(record)));
            }
            if (this.minimumKey != null) {
                builder.setMinimumKey(ZeroCopyByteString.wrap(this.adapter.serializeKey(this.minimumKey)));
            }
            if (!(childBytes = this.childContinuation.toByteString()).isEmpty()) {
                builder.setContinuation(childBytes);
            }
            this.cachedProto = builder.build();
        }
        return this.cachedProto;
    }

    @Override
    @Nonnull
    public ByteString toByteString() {
        if (this.exhausted) {
            return ByteString.EMPTY;
        }
        return this.toProto().toByteString();
    }

    @Override
    @Nullable
    public byte[] toBytes() {
        if (this.exhausted) {
            return null;
        }
        if (this.cachedBytes == null) {
            this.cachedBytes = this.toByteString().toByteArray();
        }
        return this.cachedBytes;
    }

    @Nonnull
    static <K, V> MemorySortCursorContinuation<K, V> from(@Nonnull RecordSortingProto.MemorySortContinuation parsed, @Nonnull MemorySortAdapter<K, V> adapter) {
        MemorySortCursorContinuation<Object, V> result = new MemorySortCursorContinuation<Object, V>(adapter, false, parsed.getRecordsList().stream().map(bs -> adapter.deserializeValue(bs.toByteArray())).collect(Collectors.toList()), (parsed.hasMinimumKey() ? (K)adapter.deserializeKey(parsed.getMinimumKey().toByteArray()) : null), parsed.hasContinuation() ? ByteArrayContinuation.fromNullable(parsed.getContinuation().toByteArray()) : RecordCursorStartContinuation.START);
        result.cachedProto = parsed;
        return result;
    }

    @Nonnull
    static <K, V> MemorySortCursorContinuation<K, V> from(@Nullable byte[] unparsed, @Nonnull MemorySortAdapter<K, V> adapter) {
        MemorySortCursorContinuation<Object, V> result;
        if (unparsed == null) {
            result = new MemorySortCursorContinuation<Object, V>(adapter, false, Collections.emptyList(), null, RecordCursorStartContinuation.START);
        } else {
            try {
                result = MemorySortCursorContinuation.from(RecordSortingProto.MemorySortContinuation.parseFrom(unparsed), adapter);
            }
            catch (InvalidProtocolBufferException ex) {
                throw new RecordCoreException("invalid continuation", ex).addLogInfo(new Object[]{LogMessageKeys.RAW_BYTES, ByteArrayUtil2.loggable(unparsed)});
            }
            result.cachedBytes = unparsed;
        }
        return result;
    }

    @Nonnull
    public Collection<V> getRecords() {
        return this.records;
    }

    @Nullable
    public K getMinimumKey() {
        return this.minimumKey;
    }

    @Nonnull
    RecordCursorContinuation getChild() {
        return this.childContinuation;
    }

    @Override
    public boolean isEnd() {
        return this.exhausted;
    }
}

