/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.sorting;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.sorting.MemoryScratchpad;
import com.apple.foundationdb.record.sorting.MemorySortAdapter;
import java.util.Collection;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class MemorySorter<K, V>
extends MemoryScratchpad<K, V, NavigableMap<K, V>> {
    public MemorySorter(@Nonnull MemorySortAdapter<K, V> adapter, @Nullable StoreTimer timer) {
        super(adapter, new TreeMap(adapter), timer);
    }

    @Override
    public void removeLast(@Nonnull K currentKey) {
        ((NavigableMap)this.getMap()).pollLastEntry();
    }

    @Override
    @Nonnull
    public Collection<V> tailValues(@Nullable K minimumKey) {
        return ((NavigableMap)this.getMap()).tailMap(minimumKey, false).values();
    }
}

