/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.sorting;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordSortingProto;
import com.apple.foundationdb.record.provider.common.CipherPool;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.sorting.FileSortAdapter;
import com.apple.foundationdb.record.sorting.FileSorter;
import com.apple.foundationdb.record.sorting.SortEvents;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.ExtensionRegistryLite;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.Cipher;

@API(value=API.Status.EXPERIMENTAL)
public class SortedFileReader<V>
implements AutoCloseable {
    @Nonnull
    private final FileInputStream fileStream;
    @Nonnull
    private final FileSortAdapter<?, V> adapter;
    private final boolean compressed;
    @Nullable
    private final Key encryptionKey;
    @Nullable
    private final Cipher cipher;
    @Nullable
    private final StoreTimer timer;
    private int sectionRecordStart;
    private int sectionRecordEnd;
    private int fileRecordEnd;
    private int recordPosition;
    private int recordSectionPosition;
    private long sectionFileStart;
    private long sectionFileEnd;
    @Nonnull
    private CodedInputStream headerStream;
    @Nonnull
    private CodedInputStream entryStream;

    public SortedFileReader(@Nonnull File file, @Nonnull FileSortAdapter<?, V> adapter, @Nullable StoreTimer timer, int skip, int limit) throws IOException, GeneralSecurityException {
        this.fileStream = new FileInputStream(file);
        this.adapter = adapter;
        this.entryStream = this.headerStream = CodedInputStream.newInstance(this.fileStream);
        this.compressed = adapter.isCompressed();
        this.encryptionKey = adapter.getEncryptionKey();
        String cipherName = adapter.getEncryptionCipherName();
        this.cipher = this.encryptionKey != null && cipherName != null ? CipherPool.borrowCipher(cipherName) : null;
        this.timer = timer;
        this.skipLimit(skip, limit);
    }

    private void skipLimit(int skip, int limit) throws IOException, GeneralSecurityException {
        RecordSortingProto.SortFileHeader.Builder fileHeader = RecordSortingProto.SortFileHeader.newBuilder();
        this.headerStream.readMessage(fileHeader, ExtensionRegistryLite.getEmptyRegistry());
        if (fileHeader.getVersion() != 1) {
            throw new RecordCoreException("file header version mismatch", new Object[0]);
        }
        if (fileHeader.getMetaDataVersion() != this.adapter.getMetaDataVersion()) {
            throw new RecordCoreException("file meta-data version mismatch", new Object[0]);
        }
        this.sectionFileStart = this.headerStream.getTotalBytesRead();
        this.headerStream.resetSizeCounter();
        this.sectionFileEnd = this.sectionFileStart;
        if (skip > 0) {
            long startTime;
            FileChannel fileChannel = this.fileStream.getChannel();
            if (skip >= fileHeader.getNumberOfRecords()) {
                fileChannel.position(fileChannel.size());
                this.recordPosition = this.fileRecordEnd = fileHeader.getNumberOfRecords();
                return;
            }
            while (true) {
                startTime = System.nanoTime();
                RecordSortingProto.SortSectionHeader.Builder sectionHeader = RecordSortingProto.SortSectionHeader.newBuilder();
                this.headerStream.readMessage(sectionHeader, ExtensionRegistryLite.getEmptyRegistry());
                this.sectionRecordStart = sectionHeader.getStartRecordNumber();
                this.sectionRecordEnd = this.sectionRecordStart + sectionHeader.getNumberOfRecords();
                long sectionRecordsPosition = this.sectionFileStart + (long)this.headerStream.getTotalBytesRead();
                this.sectionFileEnd = sectionRecordsPosition + sectionHeader.getNumberOfBytes();
                if (this.sectionRecordEnd > skip) {
                    this.recordPosition = sectionHeader.getStartRecordNumber();
                    this.recordSectionPosition = 0;
                    if (this.compressed || this.encryptionKey != null) {
                        if (this.cipher != null) {
                            FileSorter.initCipherDecrypt(this.cipher, this.encryptionKey, sectionHeader);
                        }
                        fileChannel.position(this.sectionFileStart + (long)this.headerStream.getTotalBytesRead());
                        InputStream inputStream = FileSorter.wrapInputStream(this.fileStream, this.cipher, this.compressed);
                        this.entryStream = CodedInputStream.newInstance(inputStream);
                        break;
                    }
                    this.entryStream = this.headerStream;
                    break;
                }
                this.sectionFileStart = this.sectionFileEnd;
                fileChannel.position(this.sectionFileStart);
                this.headerStream = CodedInputStream.newInstance(this.fileStream);
                if (this.timer == null) continue;
                this.timer.recordSinceNanoTime(SortEvents.Events.FILE_SORT_SKIP_SECTION, startTime);
            }
            while (this.recordPosition < skip) {
                startTime = System.nanoTime();
                this.entryStream.skipRawBytes(this.entryStream.readRawVarint32());
                this.entryStream.skipRawBytes(this.entryStream.readRawVarint32());
                ++this.recordPosition;
                ++this.recordSectionPosition;
                if (this.timer == null) continue;
                this.timer.recordSinceNanoTime(SortEvents.Events.FILE_SORT_SKIP_RECORD, startTime);
            }
            limit += skip;
        }
        this.fileRecordEnd = Math.min(limit, fileHeader.getNumberOfRecords());
    }

    @Nullable
    public V read() throws IOException, GeneralSecurityException {
        if (this.recordPosition >= this.fileRecordEnd) {
            return null;
        }
        long startTime = System.nanoTime();
        while (this.recordPosition >= this.sectionRecordEnd) {
            FileChannel fileChannel;
            this.sectionFileStart = this.sectionFileEnd;
            if (this.compressed || this.encryptionKey != null) {
                fileChannel = this.fileStream.getChannel();
                fileChannel.position(this.sectionFileStart);
                this.headerStream = CodedInputStream.newInstance(this.fileStream);
            } else {
                fileChannel = null;
            }
            RecordSortingProto.SortSectionHeader.Builder sectionHeader = RecordSortingProto.SortSectionHeader.newBuilder();
            this.headerStream.readMessage(sectionHeader, ExtensionRegistryLite.getEmptyRegistry());
            this.sectionRecordStart = sectionHeader.getStartRecordNumber();
            this.sectionRecordEnd = this.sectionRecordStart + sectionHeader.getNumberOfRecords();
            long sectionRecordsPosition = this.sectionFileStart + (long)this.headerStream.getTotalBytesRead();
            this.sectionFileEnd = sectionRecordsPosition + sectionHeader.getNumberOfBytes();
            this.recordPosition = sectionHeader.getStartRecordNumber();
            this.recordSectionPosition = 0;
            if (fileChannel == null) continue;
            if (this.cipher != null) {
                FileSorter.initCipherDecrypt(this.cipher, this.encryptionKey, sectionHeader);
            }
            fileChannel.position(sectionRecordsPosition);
            InputStream inputStream = FileSorter.wrapInputStream(this.fileStream, this.cipher, this.compressed);
            this.entryStream = CodedInputStream.newInstance(inputStream);
        }
        this.entryStream.skipRawBytes(this.entryStream.readRawVarint32());
        V record = this.adapter.readValue(this.entryStream);
        ++this.recordPosition;
        ++this.recordSectionPosition;
        if (this.timer != null) {
            this.timer.recordSinceNanoTime(SortEvents.Events.FILE_SORT_LOAD_RECORD, startTime);
        }
        return record;
    }

    public int getRecordPosition() {
        return this.recordPosition;
    }

    public long getFilePosition() {
        return this.sectionFileStart;
    }

    public int getRecordSectionPosition() {
        return this.recordSectionPosition;
    }

    @Override
    public void close() throws IOException {
        this.fileStream.close();
    }
}

