/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.util;

import com.apple.foundationdb.record.PlanHashable;
import com.google.protobuf.Internal;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;

public class ProtoUtils {
    private ProtoUtils() {
    }

    public static String uniqueTypeName() {
        return ProtoUtils.uniqueName("__type__");
    }

    public static String uniqueName(String prefix) {
        String safeUuid = UUID.randomUUID().toString().replace('-', '_');
        return prefix + safeUuid;
    }

    public static class DynamicEnum
    implements Internal.EnumLite,
    PlanHashable {
        private final int number;
        @Nonnull
        private final String name;

        public DynamicEnum(int number, @Nonnull String name) {
            this.number = number;
            this.name = name;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        public int getNumber() {
            return this.number;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DynamicEnum)) {
                return false;
            }
            DynamicEnum that = (DynamicEnum)o;
            return this.number == that.number && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.number, this.name);
        }

        @Override
        public int planHash(@Nonnull PlanHashable.PlanHashMode hashMode) {
            return this.name.hashCode();
        }

        public String toString() {
            return this.getName();
        }
    }
}

