/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.util;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.UNSTABLE)
public final class Result<V, E extends Throwable> {
    @Nullable
    private final V value;
    @Nullable
    private final E error;

    private Result(@Nullable V value, @Nullable E error) {
        this.value = value;
        this.error = error;
    }

    @Nullable
    public V getValue() {
        return this.value;
    }

    @Nullable
    public E getError() {
        return this.error;
    }

    public boolean isSuccess() {
        return this.error == null;
    }

    @Nonnull
    public static <V, E extends Throwable> Result<V, E> success(@Nullable V value) {
        return new Result<V, Object>(value, null);
    }

    @Nonnull
    public static <V, E extends Throwable> Result<V, E> failure(@Nonnull E error) {
        return new Result<Object, E>(null, Objects.requireNonNull(error));
    }

    @Nonnull
    public static <V, E extends Throwable> Result<V, E> of(@Nullable V value, @Nullable E error) {
        if (value != null && error != null) {
            throw new RecordCoreArgumentException("Failure result can not have value", new Object[0]);
        }
        return new Result<V, E>(value, error);
    }
}

