/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.util;

import com.apple.foundationdb.record.query.plan.cascades.TreeLike;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface TrieNode<D, T, N extends TrieNode<D, T, N>>
extends TreeLike<N> {
    @Nullable
    public T getValue();

    @Nullable
    public Map<D, N> getChildrenMap();

    @Override
    @Nonnull
    public Iterable<N> getChildren();

    @Nonnull
    public List<T> values();

    public static abstract class AbstractTrieNodeBuilder<D, T, N extends AbstractTrieNodeBuilder<D, T, N>>
    implements TrieNode<D, T, N> {
        @Nullable
        private T value;
        @Nullable
        private Map<D, N> childrenMap;

        public AbstractTrieNodeBuilder(@Nullable T value, @Nullable Map<D, N> childrenMap) {
            this.value = value;
            this.childrenMap = childrenMap == null ? null : Maps.newLinkedHashMap(childrenMap);
        }

        @Override
        @Nullable
        public T getValue() {
            return this.value;
        }

        @Nonnull
        public N setValue(@Nullable T value) {
            this.value = value;
            return (N)((AbstractTrieNodeBuilder)this.getThis());
        }

        @Override
        @Nullable
        public Map<D, N> getChildrenMap() {
            return this.childrenMap;
        }

        @Nonnull
        public N computeIfAbsent(D key, Function<D, N> mappingFunction) {
            if (this.childrenMap == null) {
                this.childrenMap = Maps.newHashMap();
            }
            return (N)((AbstractTrieNodeBuilder)this.childrenMap.computeIfAbsent(key, mappingFunction));
        }

        @Nonnull
        public N compute(D key, BiFunction<D, N, N> mappingBiFunction) {
            if (this.childrenMap == null) {
                this.childrenMap = Maps.newHashMap();
            }
            return (N)((AbstractTrieNodeBuilder)this.childrenMap.compute(key, mappingBiFunction));
        }

        @Override
        @Nonnull
        public Iterable<N> getChildren() {
            return this.childrenMap == null ? ImmutableList.of() : this.childrenMap.values();
        }

        @Override
        @Nonnull
        public N withChildren(Iterable<? extends N> newChildren) {
            throw new UnsupportedOperationException("trie does not define order among children");
        }

        @Override
        @Nonnull
        public List<T> values() {
            return this.preOrderStream().flatMap(trie -> trie.getValue() == null ? Stream.of(new Object[0]) : Stream.of(trie.getValue())).collect(ImmutableList.toImmutableList());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            AbstractTrieNodeBuilder otherTrieNode = (AbstractTrieNodeBuilder)other;
            return Objects.equals(this.getValue(), otherTrieNode.getValue()) && Objects.equals(this.getChildrenMap(), otherTrieNode.getChildrenMap());
        }

        public int hashCode() {
            return Objects.hash(this.getValue(), this.getChildrenMap());
        }
    }

    public static abstract class AbstractTrieNode<D, T, N extends AbstractTrieNode<D, T, N>>
    implements TrieNode<D, T, N> {
        @Nullable
        private final T value;
        @Nullable
        private final Map<D, N> childrenMap;
        @Nonnull
        private final Supplier<Iterable<N>> childrenSupplier;
        @Nonnull
        private final Supplier<Integer> heightSupplier;

        public AbstractTrieNode(@Nullable T value, @Nullable Map<D, N> childrenMap) {
            this.value = value;
            this.childrenMap = childrenMap == null ? null : ImmutableMap.copyOf(childrenMap);
            this.childrenSupplier = Suppliers.memoize(this::computeChildren);
            this.heightSupplier = Suppliers.memoize(() -> TrieNode.super.height());
        }

        @Override
        @Nullable
        public T getValue() {
            return this.value;
        }

        @Override
        @Nullable
        public Map<D, N> getChildrenMap() {
            return this.childrenMap;
        }

        @Override
        @Nonnull
        public Iterable<N> getChildren() {
            return this.childrenSupplier.get();
        }

        @Nonnull
        private Iterable<N> computeChildren() {
            return this.childrenMap == null ? ImmutableList.of() : this.childrenMap.values();
        }

        @Override
        public int height() {
            return this.heightSupplier.get();
        }

        @Override
        @Nonnull
        public N withChildren(Iterable<? extends N> newChildren) {
            throw new UnsupportedOperationException("trie does not define order among children");
        }

        @Override
        @Nonnull
        public List<T> values() {
            return this.preOrderStream().flatMap(trie -> trie.getValue() == null ? Stream.of(new Object[0]) : Stream.of(trie.getValue())).collect(ImmutableList.toImmutableList());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            AbstractTrieNode otherTrieNode = (AbstractTrieNode)other;
            return Objects.equals(this.getValue(), otherTrieNode.getValue()) && Objects.equals(this.getChildrenMap(), otherTrieNode.getChildrenMap());
        }

        public int hashCode() {
            return Objects.hash(this.getValue(), this.getChildrenMap());
        }
    }
}

