/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.util.pair;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.record.util.pair.Pair;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class ComparablePair<L extends Comparable<? super L>, R extends Comparable<? super R>>
implements Pair<L, R>,
Comparable<ComparablePair<L, R>> {
    @Nonnull
    private final NonnullPair<L, R> pair;

    private ComparablePair(@Nonnull NonnullPair<L, R> pair) {
        this.pair = pair;
    }

    @Override
    @Nonnull
    public L getLeft() {
        return (L)((Comparable)this.pair.getLeft());
    }

    @Override
    @Nonnull
    public R getRight() {
        return (R)((Comparable)this.pair.getRight());
    }

    @Override
    public int compareTo(ComparablePair<L, R> o) {
        int lCompare = this.getLeft().compareTo(o.getLeft());
        if (lCompare != 0) {
            return lCompare;
        }
        return this.getRight().compareTo(o.getRight());
    }

    @Override
    public R setValue(R value) {
        return (R)((Comparable)this.pair.setValue(value));
    }

    @Override
    @SpotBugsSuppressWarnings(value={"EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS", "NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="Purposefully delegating to pair member to check type and nullability of obj")
    public boolean equals(@Nullable Object obj) {
        return this.pair.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.pair.hashCode();
    }

    public String toString() {
        return this.pair.toString();
    }

    @Nonnull
    public static <L extends Comparable<? super L>, R extends Comparable<? super R>> ComparablePair<L, R> of(@Nonnull L left, @Nonnull R right) {
        return new ComparablePair<L, R>(NonnullPair.of(left, right));
    }
}

