/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.util.pair;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.util.pair.Pair;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class ImmutablePair<L, R>
implements Pair<L, R> {
    @Nullable
    private final L left;
    @Nullable
    private final R right;
    private volatile int hashCode;

    private ImmutablePair(@Nullable L left, @Nullable R right) {
        this.left = left;
        this.right = right;
    }

    @Override
    @Nullable
    public L getLeft() {
        return this.left;
    }

    @Override
    @Nullable
    public R getRight() {
        return this.right;
    }

    @Override
    public R setValue(R value) {
        throw new UnsupportedOperationException("cannot set value on an immmutable Pair");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)obj;
        return Objects.equals(this.getLeft(), other.getLeft()) && Objects.equals(this.getRight(), other.getRight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            ImmutablePair immutablePair = this;
            synchronized (immutablePair) {
                if (this.hashCode == 0) {
                    this.hashCode = Objects.hash(this.left, this.right);
                }
            }
        }
        return this.hashCode;
    }

    public String toString() {
        return "(" + String.valueOf(this.left) + ", " + String.valueOf(this.right) + ")";
    }

    @Nonnull
    public static <L, R> ImmutablePair<L, R> of(@Nullable L left, @Nullable R right) {
        return new ImmutablePair<L, R>(left, right);
    }
}

