/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.util.pair;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.util.pair.Pair;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public class NonnullPair<L, R>
implements Pair<L, R> {
    @Nonnull
    private final Pair<L, R> pair;

    private NonnullPair(@Nonnull Pair<L, R> pair) {
        this.pair = pair;
    }

    @Override
    @Nonnull
    public L getLeft() {
        return this.pair.getLeft();
    }

    @Override
    @Nonnull
    public R getRight() {
        return this.pair.getRight();
    }

    @Override
    public R setValue(R value) {
        return this.pair.setValue(Objects.requireNonNull(value));
    }

    @Override
    @SpotBugsSuppressWarnings(value={"NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION"}, justification="SpotBugs is incorrect about nullability of equals argument")
    public boolean equals(@Nullable Object obj) {
        return this.pair.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.pair.hashCode();
    }

    public String toString() {
        return this.pair.toString();
    }

    @Nonnull
    public static <L, R> NonnullPair<L, R> of(@Nonnull L left, @Nonnull R right) {
        return new NonnullPair<L, R>(Pair.of(Objects.requireNonNull(left), Objects.requireNonNull(right)));
    }
}

