/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.util.pair;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.util.pair.ImmutablePair;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.INTERNAL)
public interface Pair<L, R>
extends Map.Entry<L, R> {
    @Nullable
    public L getLeft();

    @Nullable
    public R getRight();

    @Override
    default public L getKey() {
        return this.getLeft();
    }

    @Override
    default public R getValue() {
        return this.getRight();
    }

    @Nonnull
    public static <L, R> Pair<L, R> of(@Nullable L left, @Nullable R right) {
        return ImmutablePair.of(left, right);
    }
}

