/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api;

import com.apple.foundationdb.relational.api.RelationalArray;
import com.apple.foundationdb.relational.api.RelationalArrayBuilder;
import com.apple.foundationdb.relational.api.RelationalArrayMetaData;
import com.apple.foundationdb.relational.api.RelationalStruct;
import com.apple.foundationdb.relational.api.RowArray;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.util.Assert;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface EmbeddedRelationalArray
extends RelationalArray {
    public static RelationalArrayBuilder newBuilder() {
        return new Builder();
    }

    public static RelationalArrayBuilder newBuilder(@Nonnull DataType elementType) {
        return new Builder(elementType);
    }

    public static class Builder
    implements RelationalArrayBuilder {
        @Nullable
        private DataType elementType;
        @Nonnull
        private final List<Object> elements = new ArrayList<Object>();

        private Builder() {
        }

        private Builder(@Nonnull DataType elementType) {
            this.elementType = elementType;
        }

        @Override
        public EmbeddedRelationalArray build() throws SQLException {
            if (this.elementType == null) {
                return new RowArray(List.of(), RelationalArrayMetaData.of(DataType.ArrayType.from(DataType.Primitives.NULL.type())));
            }
            return new RowArray(this.elements, RelationalArrayMetaData.of(DataType.ArrayType.from(this.elementType, false)));
        }

        @Override
        public Builder addAll(Object ... values) throws SQLException {
            for (Object value : values) {
                if (value == null) {
                    throw new RelationalException("Cannot add NULL to an array.", ErrorCode.DATATYPE_MISMATCH).toSqlException();
                }
                if (value instanceof RelationalStruct) {
                    this.addStruct((RelationalStruct)value);
                    continue;
                }
                if (value instanceof RelationalArray) {
                    throw new RelationalException("ARRAY element in ARRAY not supported.", ErrorCode.UNSUPPORTED_OPERATION).toSqlException();
                }
                DataType type = DataType.getDataTypeFromObject(value);
                this.addField(value, type);
            }
            return this;
        }

        @Override
        public Builder addLong(long value) throws SQLException {
            return this.addField(value, DataType.Primitives.LONG.type());
        }

        @Override
        public Builder addString(@Nonnull String value) throws SQLException {
            return this.addField(value, DataType.Primitives.STRING.type());
        }

        @Override
        public Builder addBytes(@Nonnull byte[] value) throws SQLException {
            return this.addField(value, DataType.Primitives.BYTES.type());
        }

        @Override
        public Builder addUuid(@Nonnull UUID uuid) throws SQLException {
            return this.addField(uuid, DataType.Primitives.UUID.type());
        }

        @Override
        public Builder addObject(@Nonnull Object obj) throws SQLException {
            if (obj instanceof RelationalStruct) {
                return this.addStruct((RelationalStruct)obj);
            }
            if (obj instanceof RelationalArray) {
                throw new RelationalException("Array objects in Array in supported", ErrorCode.INTERNAL_ERROR).toSqlException();
            }
            return this.addField(obj, DataType.getDataTypeFromObject(obj));
        }

        @Nonnull
        private Builder addField(@Nonnull Object value, @Nonnull DataType type) throws SQLException {
            try {
                this.checkType(type);
            }
            catch (RelationalException ve) {
                throw ve.toSqlException();
            }
            this.elements.add(value);
            return this;
        }

        @Override
        public Builder addStruct(RelationalStruct struct) throws SQLException {
            try {
                this.checkType(struct.getMetaData().getRelationalDataType());
            }
            catch (RelationalException ve) {
                throw ve.toSqlException();
            }
            this.elements.add(struct);
            return this;
        }

        private void checkType(DataType type) throws RelationalException {
            if (this.elementType == null) {
                this.elementType = type;
            } else if (this.elementType instanceof DataType.CompositeType) {
                Assert.that(((DataType.CompositeType)((Object)this.elementType)).hasIdenticalStructure(type), ErrorCode.DATATYPE_MISMATCH, "Expected array element to be of type:%s, but found type:%s", this.elementType, type);
            } else {
                Assert.that(this.elementType.equals(type), ErrorCode.DATATYPE_MISMATCH, "Expected array element to be of type:%s, but found type:%s", this.elementType, type);
            }
        }
    }
}

