/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.EmbeddedRelationalEngine;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.RelationalConnection;
import com.apple.foundationdb.relational.api.RelationalDriver;
import com.apple.foundationdb.relational.api.StorageCluster;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.catalog.RelationalDatabase;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class EmbeddedRelationalDriver
implements RelationalDriver {
    public static final String DRIVER_NAME = "Relational Embedded/Local JDBC Driver";
    public static final String JDBC_COLON = "jdbc:";
    public static final String JDBC_URL_PREFIX = "jdbc:embed:";
    private EmbeddedRelationalEngine engine;

    public EmbeddedRelationalDriver(@Nullable EmbeddedRelationalEngine engine) throws SQLException {
        this.engine = engine;
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return this.connect(URI.create(url), Options.fromProperties(info));
    }

    @Override
    public RelationalConnection connect(@Nonnull URI url, @Nonnull Options connectionOptions) throws SQLException {
        return this.connect(url, null, connectionOptions);
    }

    public RelationalConnection connect(@Nonnull URI url, @Nullable Transaction existingTransaction, @Nonnull Options connectionOptions) throws SQLException {
        String urlString = url.toString();
        if (!this.acceptsURL(urlString)) {
            return null;
        }
        url = URI.create(urlString.substring(JDBC_URL_PREFIX.length()));
        RelationalDatabase frl = null;
        try {
            StorageCluster cluster;
            Iterator<StorageCluster> iterator = this.engine.getStorageClusters().iterator();
            while (iterator.hasNext() && (frl = (cluster = iterator.next()).loadDatabase(url, connectionOptions)) == null) {
            }
            if (frl == null) {
                String path = url.getPath();
                if (path == null) {
                    path = url.toString();
                    if (url.getScheme() != null) {
                        path = path.replace(url.getScheme() + ":", "");
                    }
                    if (url.getAuthority() != null) {
                        path = path.replace(url.getAuthority() + ":", "");
                    }
                }
                throw new RelationalException("Database <" + path + "> does not exist", ErrorCode.UNDEFINED_DATABASE).toSqlException();
            }
            return frl.connect(existingTransaction);
        }
        catch (RelationalException ve) {
            throw ve.toSqlException();
        }
    }

    @Override
    public boolean acceptsURL(String url) {
        return url.startsWith(JDBC_URL_PREFIX);
    }
}

