/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.StorageCluster;
import com.apple.foundationdb.relational.util.SpotBugsSuppressWarnings;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class EmbeddedRelationalEngine {
    private final List<StorageCluster> clusters;
    private final MetricRegistry metricRegistry;

    @SpotBugsSuppressWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="May be refactored as embedded takes over transaction lifetime")
    public EmbeddedRelationalEngine(List<StorageCluster> fdbClusters, @Nonnull MetricRegistry metricRegistry) {
        if (fdbClusters.isEmpty()) {
            throw new IllegalArgumentException("Must specify at least one FDB cluster to connect to");
        }
        this.clusters = fdbClusters;
        this.metricRegistry = metricRegistry;
    }

    public Collection<StorageCluster> getStorageClusters() {
        return this.clusters;
    }

    public MetricSet getEngineMetrics() {
        return this.metricRegistry;
    }
}

