/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api;

import com.apple.foundationdb.relational.api.ImmutableRowStruct;
import com.apple.foundationdb.relational.api.RelationalArray;
import com.apple.foundationdb.relational.api.RelationalStruct;
import com.apple.foundationdb.relational.api.RelationalStructBuilder;
import com.apple.foundationdb.relational.api.RelationalStructMetaData;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.recordlayer.ArrayRow;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface EmbeddedRelationalStruct
extends RelationalStruct {
    public static RelationalStructBuilder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements RelationalStructBuilder {
        final List<DataType.StructType.Field> fields = new ArrayList<DataType.StructType.Field>();
        final List<Object> elements = new ArrayList<Object>();

        @Override
        public EmbeddedRelationalStruct build() {
            String name = "ANONYMOUS_STRUCT_" + UUID.randomUUID().toString().replace("-", "_");
            DataType.StructType type = DataType.StructType.from(name, this.fields, false);
            return new ImmutableRowStruct(new ArrayRow(this.elements.toArray()), RelationalStructMetaData.of(type));
        }

        @Override
        public Builder addBoolean(String fieldName, boolean b) {
            return this.addField(fieldName, DataType.Primitives.BOOLEAN.type(), b);
        }

        @Override
        public Builder addLong(String fieldName, long l) throws SQLException {
            return this.addField(fieldName, DataType.Primitives.LONG.type(), l);
        }

        @Override
        public Builder addFloat(String fieldName, float f) {
            return this.addField(fieldName, DataType.Primitives.FLOAT.type(), Float.valueOf(f));
        }

        @Override
        public Builder addDouble(String fieldName, double d) {
            return this.addField(fieldName, DataType.Primitives.DOUBLE.type(), d);
        }

        @Override
        public Builder addBytes(String fieldName, byte[] bytes) {
            return this.addField(fieldName, DataType.Primitives.BYTES.type(), bytes);
        }

        @Override
        public Builder addString(String fieldName, @Nullable String s2) {
            return this.addField(fieldName, DataType.Primitives.STRING.type(), s2);
        }

        @Override
        public Builder addUuid(String fieldName, @Nullable UUID uuid) {
            return this.addField(fieldName, DataType.Primitives.UUID.type(), uuid);
        }

        @Override
        public RelationalStructBuilder addObject(String fieldName, @Nullable Object obj) throws SQLException {
            if (obj instanceof RelationalStruct) {
                return this.addStruct(fieldName, (RelationalStruct)obj);
            }
            if (obj instanceof RelationalArray) {
                return this.addArray(fieldName, (RelationalArray)obj);
            }
            return this.addField(fieldName, DataType.getDataTypeFromObject(obj), obj);
        }

        @Override
        public Builder addStruct(String fieldName, @Nonnull RelationalStruct struct) throws SQLException {
            this.addField(fieldName, struct.getMetaData().getRelationalDataType(), struct);
            return this;
        }

        @Override
        public Builder addArray(String fieldName, @Nonnull RelationalArray array) throws SQLException {
            this.addField(fieldName, array.getMetaData().asRelationalType(), array);
            return this;
        }

        @Override
        public Builder addInt(String fieldName, int i) {
            return this.addField(fieldName, DataType.Primitives.INTEGER.type(), i);
        }

        private Builder addField(@Nonnull String fieldName, @Nonnull DataType type, @Nullable Object o) {
            this.fields.add(DataType.StructType.Field.from(fieldName, type, this.fields.size() + 1));
            this.elements.add(o);
            return this;
        }
    }
}

