/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.Row;
import com.apple.foundationdb.relational.api.RowStruct;
import com.apple.foundationdb.relational.api.StructMetaData;
import com.apple.foundationdb.relational.api.exceptions.InvalidColumnReferenceException;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import java.sql.SQLException;
import java.util.Objects;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class ImmutableRowStruct
extends RowStruct {
    private final Row theRow;

    public ImmutableRowStruct(@Nonnull Row theRow, @Nonnull StructMetaData metaData) {
        super(metaData);
        this.theRow = theRow;
    }

    @Override
    protected Object getObjectInternal(int zeroBasedPos) throws SQLException {
        this.wasNull = false;
        Objects.requireNonNull(this.theRow);
        try {
            Object o = this.theRow.getObject(zeroBasedPos);
            if (o == null) {
                this.wasNull = true;
            }
            return o;
        }
        catch (InvalidColumnReferenceException e) {
            throw e.toSqlException();
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof ImmutableRowStruct)) {
            return false;
        }
        ImmutableRowStruct otherImmutableRowStruct = (ImmutableRowStruct)other;
        if (otherImmutableRowStruct == this) {
            return true;
        }
        try {
            if (this.theRow.equals(otherImmutableRowStruct.theRow) && this.getMetaData().equals(otherImmutableRowStruct.getMetaData())) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new RelationalException(e).toUncheckedWrappedException();
        }
        return false;
    }

    public int hashCode() {
        try {
            return Objects.hash(this.theRow, this.getMetaData());
        }
        catch (SQLException e) {
            throw new RelationalException(e).toUncheckedWrappedException();
        }
    }
}

