/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@API(value=API.Status.EXPERIMENTAL)
public class KeySet {
    public static final KeySet EMPTY = new KeySet(){

        @Override
        public Map<String, Object> toMap() {
            return Collections.emptyMap();
        }

        @Override
        public KeySet setKeyColumn(String columnName, Object value) throws SQLException {
            throw new SQLException("The Empty Keyset cannot be modified", ErrorCode.UNSUPPORTED_OPERATION.getErrorCode());
        }
    };
    private Map<String, Object> keySet;

    public Map<String, Object> toMap() {
        if (this.keySet == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.keySet);
    }

    public KeySet setKeyColumn(String columnName, Object value) throws SQLException {
        if (this.keySet == null) {
            this.keySet = new HashMap<String, Object>();
        }
        this.keySet.put(columnName, value);
        return this;
    }

    public KeySet setKeyColumns(Map<String, Object> keyMap) {
        if (this.keySet == null) {
            this.keySet = new HashMap<String, Object>();
        }
        this.keySet.putAll(keyMap);
        return this;
    }

    public String toString() {
        return "KeySet{" + String.valueOf(this.keySet) + "}";
    }
}

