/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.Row;
import com.apple.foundationdb.relational.api.RowStruct;
import com.apple.foundationdb.relational.api.StructMetaData;
import com.apple.foundationdb.relational.api.exceptions.InvalidColumnReferenceException;
import java.sql.SQLException;
import java.util.Objects;

@API(value=API.Status.EXPERIMENTAL)
public class MutableRowStruct
extends RowStruct {
    private Row row;

    public MutableRowStruct(StructMetaData metaData) {
        super(metaData);
    }

    public void setRow(Row next) {
        this.row = next;
    }

    public boolean hasRow() {
        return this.row != null;
    }

    @Override
    protected Object getObjectInternal(int zeroBasedPos) throws SQLException {
        this.wasNull = false;
        Objects.requireNonNull(this.row);
        try {
            Object o = this.row.getObject(zeroBasedPos);
            if (o == null) {
                this.wasNull = true;
            }
            return o;
        }
        catch (InvalidColumnReferenceException e) {
            throw e.toSqlException();
        }
    }
}

