/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.Continuation;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.options.CollectionContract;
import com.apple.foundationdb.relational.api.options.OptionContract;
import com.apple.foundationdb.relational.api.options.OptionContractWithConversion;
import com.apple.foundationdb.relational.api.options.OrderedCollectionContract;
import com.apple.foundationdb.relational.api.options.RangeContract;
import com.apple.foundationdb.relational.api.options.TypeContract;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public final class Options {
    private static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();
    private static final Map<Name, List<OptionContract>> OPTIONS = Options.makeContracts();
    @Nonnull
    private static final Map<Name, Object> OPTIONS_DEFAULT_VALUES;
    private static final Object NULL_STANDIN;
    public static final Options NONE;
    @Nullable
    private final Options parentOptions;
    @Nonnull
    private final Map<Name, Object> optionsMap;

    @Nonnull
    public static Options none() {
        return NONE;
    }

    @Nonnull
    public static Map<Name, Object> defaultOptions() {
        return OPTIONS_DEFAULT_VALUES;
    }

    private Options(@Nonnull Map<Name, Object> optionsMap, @Nullable Options parentOptions) {
        this.optionsMap = optionsMap;
        this.parentOptions = parentOptions;
    }

    public <T> T getOption(@Nonnull Name name) {
        T option = this.getOptionInternal(name);
        if (option == null) {
            return (T)OPTIONS_DEFAULT_VALUES.get((Object)name);
        }
        return option;
    }

    public Options withOption(@Nonnull Name name, @Nullable Object value) throws SQLException {
        return Options.builder().fromOptions(this).withOption(name, value).build();
    }

    public Options withChild(@Nonnull Options childOptions) throws SQLException {
        return Options.combine(this, childOptions);
    }

    @Nonnull
    private static Options combine(@Nonnull Options parentOptions, @Nonnull Options childOptions) throws SQLException {
        if (childOptions.parentOptions != null) {
            throw new SQLException("Cannot override parent options", ErrorCode.INTERNAL_ERROR.getErrorCode());
        }
        if (parentOptions == childOptions) {
            return childOptions;
        }
        return new Options(childOptions.optionsMap, parentOptions);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    private static Object parseStringOption(@Nonnull Name name, String valueAsString) throws SQLException {
        for (OptionContract contract : Objects.requireNonNull(OPTIONS).get((Object)name)) {
            if (!(contract instanceof OptionContractWithConversion)) continue;
            return ((OptionContractWithConversion)contract).fromString(valueAsString);
        }
        throw new SQLException("option must have at least one type contract", ErrorCode.INTERNAL_ERROR.getErrorCode());
    }

    private static void validateOption(@Nonnull Name name, Object value) throws SQLException {
        for (OptionContract contract : Objects.requireNonNull(OPTIONS).get((Object)name)) {
            contract.validate(name, value);
        }
    }

    @Nullable
    private <T> T getOptionInternal(Name name) {
        Object option = this.optionsMap.get((Object)name);
        if (option == NULL_STANDIN) {
            return null;
        }
        if (option == null && this.parentOptions != null) {
            return this.parentOptions.getOption(name);
        }
        return (T)option;
    }

    @Nonnull
    public Iterable<? extends Map.Entry<Name, ?>> entries() {
        if (this.parentOptions != null) {
            return Iterables.concat(this.parentOptions.entries(), this.optionsMap.entrySet());
        }
        return this.optionsMap.entrySet();
    }

    public static boolean isNull(@Nullable Object object) {
        return object == null || object == NULL_STANDIN;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Options)) {
            return false;
        }
        Options options = (Options)o;
        return Objects.equals(this.parentOptions, options.parentOptions) && this.optionsMap.equals(options.optionsMap);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.parentOptions);
        result = 31 * result + this.optionsMap.hashCode();
        return result;
    }

    public static Options fromProperties(@Nullable Properties properties) throws SQLException {
        if (properties == null) {
            return Options.none();
        }
        Builder builder = Options.builder();
        for (String key : properties.stringPropertyNames()) {
            Name name = Name.valueOf(key);
            builder.withOptionFromString(name, properties.getProperty(key));
        }
        return builder.build();
    }

    @Nonnull
    public static Properties toProperties(Options options) {
        Properties result = new Properties();
        for (Map.Entry<Name, ?> entry : options.entries()) {
            String prop;
            switch (entry.getKey()) {
                case CONTINUATION: {
                    prop = Options.bytesToHex(((Continuation)entry.getValue()).serialize());
                    break;
                }
                case DISABLED_PLANNER_RULES: 
                case ENCRYPTION_KEY_ENTRY_LIST: {
                    prop = String.join((CharSequence)",", (Collection)entry.getValue());
                    break;
                }
                default: {
                    prop = entry.getValue().toString();
                }
            }
            result.put(entry.getKey().name(), prop);
        }
        return result;
    }

    private static String bytesToHex(@Nonnull byte[] bytes) {
        char[] hex = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            hex[i * 2] = HEX_CHARS[b >>> 4];
            hex[i * 2 + 1] = HEX_CHARS[b & 0xF];
        }
        return new String(hex);
    }

    private static Map<Name, List<OptionContract>> makeContracts() {
        EnumMap<Name, List<OptionContract>> data = new EnumMap<Name, List<OptionContract>>(Name.class);
        data.put(Name.CONTINUATION, List.of(TypeContract.of(Continuation.class, ignored -> {
            throw new UnsupportedOperationException();
        })));
        data.put(Name.MAX_ROWS, List.of(TypeContract.intType(), RangeContract.of(0, Integer.MAX_VALUE)));
        data.put(Name.INDEX_FETCH_METHOD, List.of(TypeContract.of(IndexFetchMethod.class, IndexFetchMethod::valueOf)));
        data.put(Name.DISABLE_PLANNER_REWRITING, List.of(TypeContract.booleanType()));
        data.put(Name.DISABLED_PLANNER_RULES, List.of(new CollectionContract<String>(TypeContract.stringType())));
        data.put(Name.INDEX_HINT, List.of(TypeContract.stringType()));
        data.put(Name.PLAN_CACHE_PRIMARY_MAX_ENTRIES, List.of(TypeContract.intType(), RangeContract.of(0, Integer.MAX_VALUE)));
        data.put(Name.PLAN_CACHE_PRIMARY_TIME_TO_LIVE_MILLIS, List.of(TypeContract.longType(), RangeContract.of(10L, Long.MAX_VALUE)));
        data.put(Name.PLAN_CACHE_SECONDARY_MAX_ENTRIES, List.of(TypeContract.intType(), RangeContract.of(1, Integer.MAX_VALUE)));
        data.put(Name.PLAN_CACHE_SECONDARY_TIME_TO_LIVE_MILLIS, List.of(TypeContract.longType(), RangeContract.of(10L, Long.MAX_VALUE)));
        data.put(Name.PLAN_CACHE_TERTIARY_MAX_ENTRIES, List.of(TypeContract.intType(), RangeContract.of(1, Integer.MAX_VALUE)));
        data.put(Name.PLAN_CACHE_TERTIARY_TIME_TO_LIVE_MILLIS, List.of(TypeContract.longType(), RangeContract.of(10L, Long.MAX_VALUE)));
        data.put(Name.REPLACE_ON_DUPLICATE_PK, List.of(TypeContract.booleanType()));
        data.put(Name.REQUIRED_METADATA_TABLE_VERSION, List.of(TypeContract.intType(), RangeContract.of(-1, Integer.MAX_VALUE)));
        data.put(Name.TRANSACTION_TIMEOUT, List.of(TypeContract.longType(), RangeContract.of(-1L, Long.MAX_VALUE)));
        data.put(Name.LOG_QUERY, List.of(TypeContract.booleanType()));
        data.put(Name.LOG_SLOW_QUERY_THRESHOLD_MICROS, List.of(TypeContract.longType(), RangeContract.of(0L, Long.MAX_VALUE)));
        data.put(Name.EXECUTION_TIME_LIMIT, List.of(TypeContract.longType(), RangeContract.of(0L, Long.MAX_VALUE)));
        data.put(Name.EXECUTION_SCANNED_ROWS_LIMIT, List.of(TypeContract.intType(), RangeContract.of(0, Integer.MAX_VALUE)));
        data.put(Name.EXECUTION_SCANNED_BYTES_LIMIT, List.of(TypeContract.longType(), RangeContract.of(0L, Long.MAX_VALUE)));
        data.put(Name.DRY_RUN, List.of(TypeContract.booleanType()));
        data.put(Name.CASE_SENSITIVE_IDENTIFIERS, List.of(TypeContract.booleanType()));
        data.put(Name.CURRENT_PLAN_HASH_MODE, List.of(TypeContract.stringType()));
        data.put(Name.VALID_PLAN_HASH_MODES, List.of(TypeContract.stringType()));
        data.put(Name.ASYNC_OPERATIONS_TIMEOUT_MILLIS, List.of(TypeContract.longType(), RangeContract.of(0L, Long.MAX_VALUE)));
        data.put(Name.ENCRYPT_WHEN_SERIALIZING, List.of(TypeContract.booleanType()));
        data.put(Name.ENCRYPTION_KEY_STORE, List.of(TypeContract.nullableStringType()));
        data.put(Name.ENCRYPTION_KEY_ENTRY, List.of(TypeContract.nullableStringType()));
        data.put(Name.ENCRYPTION_KEY_ENTRY_LIST, List.of(new OrderedCollectionContract<String>(TypeContract.stringType())));
        data.put(Name.ENCRYPTION_KEY_PASSWORD, List.of(TypeContract.nullableStringType()));
        data.put(Name.COMPRESS_WHEN_SERIALIZING, List.of(TypeContract.booleanType()));
        return Collections.unmodifiableMap(data);
    }

    static {
        NULL_STANDIN = new Object();
        ImmutableMap.Builder<Name, Object> builder = ImmutableMap.builder();
        builder.put(Name.MAX_ROWS, Integer.MAX_VALUE);
        builder.put(Name.INDEX_FETCH_METHOD, (Object)IndexFetchMethod.USE_REMOTE_FETCH_WITH_FALLBACK);
        builder.put(Name.DISABLE_PLANNER_REWRITING, false);
        builder.put(Name.DISABLED_PLANNER_RULES, ImmutableSet.of());
        builder.put(Name.PLAN_CACHE_PRIMARY_MAX_ENTRIES, 1024);
        builder.put(Name.PLAN_CACHE_PRIMARY_TIME_TO_LIVE_MILLIS, 10000L);
        builder.put(Name.PLAN_CACHE_SECONDARY_MAX_ENTRIES, 256);
        builder.put(Name.PLAN_CACHE_SECONDARY_TIME_TO_LIVE_MILLIS, 30000L);
        builder.put(Name.PLAN_CACHE_TERTIARY_MAX_ENTRIES, 8);
        builder.put(Name.PLAN_CACHE_TERTIARY_TIME_TO_LIVE_MILLIS, 30000L);
        builder.put(Name.REPLACE_ON_DUPLICATE_PK, false);
        builder.put(Name.LOG_QUERY, false);
        builder.put(Name.LOG_SLOW_QUERY_THRESHOLD_MICROS, 2000000L);
        builder.put(Name.EXECUTION_SCANNED_BYTES_LIMIT, Long.MAX_VALUE);
        builder.put(Name.EXECUTION_TIME_LIMIT, 0L);
        builder.put(Name.EXECUTION_SCANNED_ROWS_LIMIT, Integer.MAX_VALUE);
        builder.put(Name.DRY_RUN, false);
        builder.put(Name.CASE_SENSITIVE_IDENTIFIERS, false);
        builder.put(Name.ASYNC_OPERATIONS_TIMEOUT_MILLIS, 10000L);
        builder.put(Name.ENCRYPT_WHEN_SERIALIZING, false);
        builder.put(Name.ENCRYPTION_KEY_PASSWORD, "");
        builder.put(Name.COMPRESS_WHEN_SERIALIZING, true);
        OPTIONS_DEFAULT_VALUES = builder.build();
        NONE = Options.builder().build();
    }

    public static enum Name {
        CONTINUATION,
        INDEX_HINT,
        MAX_ROWS,
        REQUIRED_METADATA_TABLE_VERSION,
        TRANSACTION_TIMEOUT,
        REPLACE_ON_DUPLICATE_PK,
        PLAN_CACHE_PRIMARY_MAX_ENTRIES,
        PLAN_CACHE_SECONDARY_MAX_ENTRIES,
        PLAN_CACHE_TERTIARY_MAX_ENTRIES,
        PLAN_CACHE_PRIMARY_TIME_TO_LIVE_MILLIS,
        PLAN_CACHE_SECONDARY_TIME_TO_LIVE_MILLIS,
        PLAN_CACHE_TERTIARY_TIME_TO_LIVE_MILLIS,
        INDEX_FETCH_METHOD,
        DISABLED_PLANNER_RULES,
        DISABLE_PLANNER_REWRITING,
        LOG_QUERY,
        LOG_SLOW_QUERY_THRESHOLD_MICROS,
        EXECUTION_TIME_LIMIT,
        EXECUTION_SCANNED_BYTES_LIMIT,
        EXECUTION_SCANNED_ROWS_LIMIT,
        DRY_RUN,
        CASE_SENSITIVE_IDENTIFIERS,
        CURRENT_PLAN_HASH_MODE,
        VALID_PLAN_HASH_MODES,
        ASYNC_OPERATIONS_TIMEOUT_MILLIS,
        ENCRYPT_WHEN_SERIALIZING,
        ENCRYPTION_KEY_STORE,
        ENCRYPTION_KEY_ENTRY,
        ENCRYPTION_KEY_ENTRY_LIST,
        ENCRYPTION_KEY_PASSWORD,
        COMPRESS_WHEN_SERIALIZING;

    }

    public static final class Builder {
        @Nonnull
        private final Map<Name, Object> optionsMap = Maps.newHashMap();
        @Nullable
        private Options parentOptions;

        private Builder() {
        }

        @Nonnull
        public Builder withOptionFromString(Name name, String valueAsString) throws SQLException {
            Object value = Options.parseStringOption(name, valueAsString);
            return this.withOption(name, value);
        }

        @Nonnull
        public Builder withOption(@Nonnull Name name, @Nullable Object value) throws SQLException {
            if (value == NULL_STANDIN) {
                this.optionsMap.put(name, NULL_STANDIN);
            } else {
                Options.validateOption(name, value);
                if (value == null) {
                    this.optionsMap.put(name, NULL_STANDIN);
                } else {
                    this.optionsMap.put(name, value);
                }
            }
            return this;
        }

        @Nonnull
        public Builder fromOptions(Options options) throws SQLException {
            this.optionsMap.putAll(options.optionsMap);
            if (this.parentOptions != null) {
                throw new SQLException("parentOptions are NOT null", ErrorCode.INTERNAL_ERROR.getErrorCode());
            }
            this.parentOptions = options.parentOptions;
            return this;
        }

        @VisibleForTesting
        public void setParentOption(@Nullable Options parentOptions) {
            this.parentOptions = parentOptions;
        }

        @Nonnull
        public Options build() {
            return new Options(ImmutableMap.copyOf(this.optionsMap), this.parentOptions);
        }
    }

    public static enum IndexFetchMethod {
        SCAN_AND_FETCH,
        USE_REMOTE_FETCH,
        USE_REMOTE_FETCH_WITH_FALLBACK;

    }
}

