/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.DynamicMessageBuilder;
import com.apple.foundationdb.relational.api.ddl.ProtobufDdlUtil;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.InvalidTypeException;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.util.NullableArrayUtils;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@Deprecated
@API(value=API.Status.EXPERIMENTAL)
public class ProtobufDataBuilder
implements DynamicMessageBuilder {
    private final Descriptors.Descriptor typeDescriptor;
    private DynamicMessage.Builder data;

    public ProtobufDataBuilder(Descriptors.Descriptor typeDescriptor) {
        this.typeDescriptor = typeDescriptor;
        this.data = DynamicMessage.newBuilder(typeDescriptor);
    }

    @Override
    public Set<String> getFieldNames() {
        return this.typeDescriptor.getFields().stream().map(Descriptors.FieldDescriptor::getName).collect(Collectors.toSet());
    }

    @Override
    public String getFieldType(String fieldName) throws SQLException {
        Descriptors.FieldDescriptor field = this.typeDescriptor.findFieldByName(fieldName);
        if (field == null) {
            throw new RelationalException(String.format(Locale.ROOT, "Field <%s> does not exist", fieldName), ErrorCode.INVALID_PARAMETER).toSqlException();
        }
        return ProtobufDdlUtil.getTypeName(field);
    }

    @Override
    public boolean isPrimitive(int fieldNumber) throws SQLException {
        Descriptors.FieldDescriptor field = this.typeDescriptor.getFields().get(fieldNumber - 1);
        if (field == null) {
            throw new RelationalException(String.format(Locale.ROOT, "Field with number <%d> does not exist", fieldNumber), ErrorCode.INVALID_PARAMETER).toSqlException();
        }
        return !field.isRepeated() && !field.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.MESSAGE);
    }

    @Override
    public DynamicMessageBuilder setField(String fieldName, Object value) throws SQLException {
        try {
            Descriptors.FieldDescriptor field = this.typeDescriptor.findFieldByName(fieldName);
            if (field == null) {
                throw new RelationalException(String.format(Locale.ROOT, "Field <%s> does not exist", fieldName), ErrorCode.INVALID_PARAMETER);
            }
            return this.setFieldInternal(field, value);
        }
        catch (RelationalException e) {
            throw e.toSqlException();
        }
    }

    @Override
    public DynamicMessageBuilder setField(int fieldNumber, Object value) throws SQLException {
        try {
            Descriptors.FieldDescriptor field = this.typeDescriptor.getFields().get(fieldNumber - 1);
            if (field == null) {
                throw new RelationalException(String.format(Locale.ROOT, "Field with number (%d) does not exist", fieldNumber), ErrorCode.INVALID_PARAMETER);
            }
            return this.setFieldInternal(field, value);
        }
        catch (RelationalException e) {
            throw e.toSqlException();
        }
    }

    private DynamicMessageBuilder setFieldInternal(@Nonnull Descriptors.FieldDescriptor field, Object value) throws RelationalException {
        this.data.setField(field, this.coerceObject(value, field));
        return this;
    }

    @Override
    public DynamicMessageBuilder addRepeatedField(String fieldName, Object value) throws SQLException {
        try {
            Descriptors.FieldDescriptor field = this.typeDescriptor.findFieldByName(fieldName);
            if (field == null) {
                throw new RelationalException("Field <" + fieldName + "> does not exist", ErrorCode.INVALID_PARAMETER);
            }
            if (!field.isRepeated()) {
                throw new RelationalException("Field <" + fieldName + "> is not repeated", ErrorCode.INVALID_PARAMETER);
            }
            return this.addRepeatedFieldInternal(field, value);
        }
        catch (RelationalException e) {
            throw e.toSqlException();
        }
    }

    @Override
    public DynamicMessageBuilder addRepeatedField(int fieldNumber, Object value) throws SQLException {
        try {
            Descriptors.FieldDescriptor field = this.typeDescriptor.getFields().get(fieldNumber - 1);
            if (field == null) {
                throw new RelationalException(String.format(Locale.ROOT, "Field with number (%d) does not exist", fieldNumber), ErrorCode.INVALID_PARAMETER);
            }
            if (!field.isRepeated()) {
                throw new RelationalException("Field with number <" + fieldNumber + "> is not repeated", ErrorCode.INVALID_PARAMETER);
            }
            return this.addRepeatedFieldInternal(field, value);
        }
        catch (RelationalException e) {
            throw e.toSqlException();
        }
    }

    @Nonnull
    private DynamicMessageBuilder addRepeatedFieldInternal(@Nonnull Descriptors.FieldDescriptor field, Object value) throws RelationalException {
        this.data.addRepeatedField(field, this.coerceObject(value, field));
        return this;
    }

    @Override
    public DynamicMessageBuilder addRepeatedFields(String fieldName, Iterable<? extends Object> values, boolean isNullableArray) throws SQLException {
        try {
            if (isNullableArray) {
                DynamicMessageBuilder builder = this.getNestedMessageBuilder(fieldName);
                builder.addRepeatedFields(NullableArrayUtils.getRepeatedFieldName(), values, false);
                this.setField(fieldName, (Object)builder.build());
            } else {
                for (Object object : values) {
                    if (object == null) {
                        throw new RelationalException("Cannot add a null value to a non-nullable array", ErrorCode.NOT_NULL_VIOLATION);
                    }
                    this.addRepeatedField(fieldName, object);
                }
            }
            return this;
        }
        catch (RelationalException e) {
            throw e.toSqlException();
        }
    }

    @Override
    public DynamicMessageBuilder addRepeatedFields(String fieldName, Iterable<? extends Object> values) throws SQLException {
        return this.addRepeatedFields(fieldName, values, true);
    }

    @Override
    public DynamicMessageBuilder addRepeatedFields(int fieldNumber, Iterable<? extends Object> values) throws SQLException {
        for (Object object : values) {
            this.addRepeatedField(fieldNumber, object);
        }
        return this;
    }

    @Override
    public Message build() {
        return this.data.build();
    }

    @Override
    public <T extends Message> Message convertMessage(T m4) throws SQLException {
        try {
            return this.convert(m4, this.typeDescriptor);
        }
        catch (RelationalException e) {
            throw e.toSqlException();
        }
    }

    @Override
    public DynamicMessageBuilder getNestedMessageBuilder(String fieldName) throws SQLException {
        try {
            for (Descriptors.FieldDescriptor fd : this.typeDescriptor.getFields()) {
                if (!fd.getName().equals(fieldName)) continue;
                if (fd.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                    throw new RelationalException("Cannot get Nested data builder for field " + fieldName + " as it is not a nested structure", ErrorCode.INVALID_PARAMETER);
                }
                return new ProtobufDataBuilder(fd.getMessageType());
            }
            throw new RelationalException("Field <" + fieldName + "> does not exist in this Type", ErrorCode.INVALID_PARAMETER);
        }
        catch (RelationalException e) {
            throw e.toSqlException();
        }
    }

    @Override
    public DynamicMessageBuilder getNestedMessageBuilder(int fieldNumber) throws SQLException {
        try {
            Descriptors.FieldDescriptor fd = this.typeDescriptor.getFields().get(fieldNumber - 1);
            if (fd.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                throw new RelationalException("Cannot get Nested data builder for field with number <" + fieldNumber + "> as it is not a nested structure", ErrorCode.INVALID_PARAMETER);
            }
            return new ProtobufDataBuilder(fd.getMessageType());
        }
        catch (RelationalException e) {
            throw e.toSqlException();
        }
    }

    @Override
    public Descriptors.Descriptor getDescriptor() {
        return this.typeDescriptor;
    }

    @Override
    @Nonnull
    public DynamicMessageBuilder newBuilder() {
        return new ProtobufDataBuilder(this.typeDescriptor);
    }

    private Message convert(Message m4, Descriptors.Descriptor destinationDescriptor) throws RelationalException {
        if (m4.getDescriptorForType() == destinationDescriptor) {
            return m4;
        }
        DynamicMessage.Builder newMessage = DynamicMessage.newBuilder(destinationDescriptor);
        for (Descriptors.FieldDescriptor field : destinationDescriptor.getFields()) {
            Descriptors.FieldDescriptor messageField = m4.getDescriptorForType().findFieldByName(field.getName());
            if (messageField == null) {
                if (field.isOptional()) continue;
                throw new RelationalException("Field <" + field.getName() + "> is missing from passed object", ErrorCode.INVALID_PARAMETER);
            }
            if (!this.canCoerce(messageField.getJavaType(), field.getJavaType())) {
                throw new RelationalException("Field <" + field.getName() + "> is of incorrect type", ErrorCode.INVALID_PARAMETER);
            }
            if (field.isRepeated() && !messageField.isRepeated()) {
                throw new RelationalException("Field <" + field.getName() + "> should be repeated", ErrorCode.INVALID_PARAMETER);
            }
            if (!field.isRepeated() && messageField.isRepeated()) {
                throw new RelationalException("Field <" + field.getName() + "> should not be repeated", ErrorCode.INVALID_PARAMETER);
            }
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                Descriptors.Descriptor messageDesc = field.getMessageType();
                if (field.isRepeated()) {
                    for (int i = 0; i < m4.getRepeatedFieldCount(messageField); ++i) {
                        Message converted = this.convert((Message)m4.getRepeatedField(messageField, i), messageDesc);
                        newMessage.addRepeatedField(field, converted);
                    }
                    continue;
                }
                if (!m4.hasField(messageField)) continue;
                Message converted = this.convert((Message)m4.getField(messageField), messageDesc);
                newMessage.setField(field, converted);
                continue;
            }
            if (field.isRepeated()) {
                for (int i = 0; i < m4.getRepeatedFieldCount(messageField); ++i) {
                    Object coerced = this.coerceObject(m4.getRepeatedField(messageField, i), field);
                    newMessage.addRepeatedField(field, coerced);
                }
                continue;
            }
            if (!m4.hasField(messageField)) continue;
            Object coerced = this.coerceObject(m4.getField(messageField), field);
            newMessage.setField(field, coerced);
        }
        return newMessage.build();
    }

    private Object coerceObject(Object value, Descriptors.FieldDescriptor fieldDescriptor) throws RelationalException {
        Descriptors.FieldDescriptor.JavaType destType = fieldDescriptor.getJavaType();
        if (value instanceof Number) {
            Number n = (Number)value;
            switch (destType) {
                case INT: {
                    value = n.intValue();
                    break;
                }
                case LONG: {
                    value = n.longValue();
                    break;
                }
                case FLOAT: {
                    value = Float.valueOf(n.floatValue());
                    break;
                }
                case DOUBLE: {
                    value = n.doubleValue();
                    break;
                }
                case STRING: {
                    value = n.toString();
                    break;
                }
                case ENUM: {
                    throw new InvalidTypeException("Invalid enum value " + String.valueOf(n));
                }
            }
        } else if (value instanceof String) {
            String str = (String)value;
            switch (destType) {
                case INT: {
                    value = Integer.parseInt(str);
                    break;
                }
                case LONG: {
                    value = Long.parseLong(str);
                    break;
                }
                case FLOAT: {
                    value = Float.valueOf(Float.parseFloat(str));
                    break;
                }
                case DOUBLE: {
                    value = Double.parseDouble(str);
                    break;
                }
                case ENUM: {
                    value = fieldDescriptor.getEnumType().findValueByName(str);
                    if (value != null) break;
                    throw new InvalidTypeException("Invalid enum value '" + str + "'");
                }
            }
        }
        return value;
    }

    private boolean canCoerce(Descriptors.FieldDescriptor.JavaType srcType, Descriptors.FieldDescriptor.JavaType destType) {
        if (srcType == Descriptors.FieldDescriptor.JavaType.INT) {
            switch (destType) {
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: {
                    return true;
                }
            }
            return false;
        }
        if (srcType == Descriptors.FieldDescriptor.JavaType.FLOAT) {
            switch (destType) {
                case FLOAT: 
                case DOUBLE: {
                    return true;
                }
            }
            return false;
        }
        return srcType == destType;
    }
}

