/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api;

import com.apple.foundationdb.relational.api.ArrayMetaData;
import com.apple.foundationdb.relational.api.RelationalResultSet;
import com.apple.foundationdb.relational.api.SqlTypeNamesSupport;
import java.sql.Array;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.Map;

public interface RelationalArray
extends Array,
Wrapper {
    public ArrayMetaData getMetaData() throws SQLException;

    @Override
    default public Object getArray() throws SQLException {
        return this.getArray(1L, Integer.MAX_VALUE);
    }

    @Override
    default public Object getArray(long oneBasedIndex, int count) throws SQLException {
        ArrayList<Object> array = new ArrayList<Object>();
        RelationalResultSet rs = this.getResultSet(oneBasedIndex, count);
        while (rs.next()) {
            array.add(rs.getObject(2));
        }
        return array.toArray();
    }

    @Override
    default public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Custom type mapping is not supported in Relational Arrays");
    }

    @Override
    default public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Custom type mapping is not supported in Relational Arrays");
    }

    @Override
    public RelationalResultSet getResultSet(long var1, int var3) throws SQLException;

    @Override
    default public RelationalResultSet getResultSet() throws SQLException {
        return this.getResultSet(1L, Integer.MAX_VALUE);
    }

    @Override
    default public RelationalResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Custom type mapping is not supported in Relational Arrays");
    }

    @Override
    default public RelationalResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Custom type mapping is not supported in Relational Arrays");
    }

    @Override
    default public String getBaseTypeName() throws SQLException {
        return SqlTypeNamesSupport.getSqlTypeName(this.getBaseType());
    }

    @Override
    default public void free() {
    }

    @Override
    default public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException("Unwrap failed for: " + String.valueOf(iface));
    }

    @Override
    default public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

