/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.ArrayMetaData;
import com.apple.foundationdb.relational.api.RelationalStructMetaData;
import com.apple.foundationdb.relational.api.SqlTypeNamesSupport;
import com.apple.foundationdb.relational.api.StructMetaData;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.google.common.base.Suppliers;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public final class RelationalArrayMetaData
implements ArrayMetaData {
    private final DataType.ArrayType type;
    private final Supplier<Integer> hashCodeSupplier;

    private RelationalArrayMetaData(@Nonnull DataType.ArrayType type) {
        this.type = type;
        this.hashCodeSupplier = Suppliers.memoize(this::calculateHashCode);
    }

    @Nonnull
    public static RelationalArrayMetaData of(@Nonnull DataType.ArrayType type) {
        return new RelationalArrayMetaData(type);
    }

    @Override
    public int isElementNullable() {
        if (this.type.getElementType().isNullable()) {
            return 1;
        }
        return 0;
    }

    @Override
    public String getElementName() throws SQLException {
        return "VALUE";
    }

    @Override
    public int getElementType() throws SQLException {
        return this.type.getElementType().getJdbcSqlCode();
    }

    @Override
    public String getElementTypeName() {
        return SqlTypeNamesSupport.getSqlTypeName(this.type.getElementType().getJdbcSqlCode());
    }

    @Override
    public StructMetaData getElementStructMetaData() throws SQLException {
        if (this.type.getElementType().getCode() != DataType.Code.STRUCT) {
            throw new RelationalException("Element is not of STRUCT type", ErrorCode.CANNOT_CONVERT_TYPE).toSqlException();
        }
        return RelationalStructMetaData.of((DataType.StructType)this.type.getElementType());
    }

    @Override
    public ArrayMetaData getElementArrayMetaData() throws SQLException {
        if (this.type.getElementType().getCode() != DataType.Code.ARRAY) {
            throw new RelationalException("Element is not of ARRAY type", ErrorCode.CANNOT_CONVERT_TYPE).toSqlException();
        }
        return RelationalArrayMetaData.of((DataType.ArrayType)this.type.getElementType());
    }

    @Override
    @Nonnull
    public DataType.ArrayType asRelationalType() throws SQLException {
        return this.type;
    }

    @Nonnull
    public DataType getElementDataType() {
        return this.type.getElementType();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    public boolean equals(Object other) {
        if (!(other instanceof RelationalArrayMetaData)) {
            return false;
        }
        RelationalArrayMetaData otherMetadata = (RelationalArrayMetaData)other;
        if (otherMetadata == this) {
            return true;
        }
        return this.type.equals(otherMetadata.type);
    }

    public int hashCode() {
        return this.hashCodeSupplier.get();
    }

    private int calculateHashCode() {
        return Objects.hash(this.type);
    }
}

