/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api;

import com.apple.foundationdb.relational.api.KeySet;
import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.RelationalResultSet;
import com.apple.foundationdb.relational.api.RelationalStruct;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public interface RelationalDirectAccessStatement
extends AutoCloseable {
    @Nonnull
    public RelationalResultSet executeScan(@Nonnull String var1, @Nonnull KeySet var2, @Nonnull Options var3) throws SQLException;

    @Nonnull
    public RelationalResultSet executeGet(@Nonnull String var1, @Nonnull KeySet var2, @Nonnull Options var3) throws SQLException;

    default public int executeInsert(@Nonnull String tableName, @Nonnull RelationalStruct data) throws SQLException {
        return this.executeInsert(tableName, Collections.singletonList(data), Options.NONE);
    }

    default public int executeInsert(@Nonnull String tableName, @Nonnull RelationalStruct data, @Nonnull Options options) throws SQLException {
        return this.executeInsert(tableName, Collections.singletonList(data), options);
    }

    default public int executeInsert(@Nonnull String tableName, @Nonnull List<RelationalStruct> data) throws SQLException {
        return this.executeInsert(tableName, data, Options.NONE);
    }

    public int executeInsert(@Nonnull String var1, @Nonnull List<RelationalStruct> var2, @Nonnull Options var3) throws SQLException;

    default public int executeDelete(@Nonnull String tableName, @Nonnull Iterable<KeySet> keys) throws SQLException {
        return this.executeDelete(tableName, keys.iterator(), Options.NONE);
    }

    default public int executeDelete(@Nonnull String tableName, @Nonnull Iterable<KeySet> keys, @Nonnull Options options) throws SQLException {
        return this.executeDelete(tableName, keys.iterator(), options);
    }

    default public int executeDelete(@Nonnull String tableName, @Nonnull Iterator<KeySet> keys) throws SQLException {
        return this.executeDelete(tableName, keys, Options.NONE);
    }

    public int executeDelete(@Nonnull String var1, @Nonnull Iterator<KeySet> var2, @Nonnull Options var3) throws SQLException;

    public void executeDeleteRange(@Nonnull String var1, @Nonnull KeySet var2, @Nonnull Options var3) throws SQLException;

    @Override
    public void close() throws SQLException;
}

