/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api;

import com.apple.foundationdb.relational.api.Options;
import com.apple.foundationdb.relational.api.RelationalConnection;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.util.BuildVersion;
import java.net.URI;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public interface RelationalDriver
extends Driver {
    default public RelationalConnection connect(@Nonnull URI url) throws SQLException {
        return this.connect(url, Options.NONE);
    }

    public RelationalConnection connect(@Nonnull URI var1, @Nonnull Options var2) throws SQLException;

    @Override
    default public int getMajorVersion() {
        try {
            return BuildVersion.getInstance().getMajorVersion();
        }
        catch (RelationalException e) {
            throw e.toUncheckedWrappedException();
        }
    }

    @Override
    default public int getMinorVersion() {
        try {
            return BuildVersion.getInstance().getMinorVersion();
        }
        catch (RelationalException e) {
            throw e.toUncheckedWrappedException();
        }
    }

    @Override
    default public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not Implemented in the Relational layer");
    }

    @Override
    default public boolean jdbcCompliant() {
        return false;
    }

    @Override
    default public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not Implemented in the Relational layer");
    }
}

