/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api;

import com.apple.foundationdb.relational.api.RelationalArray;
import com.apple.foundationdb.relational.api.StructMetaData;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.InvalidColumnReferenceException;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Wrapper;
import java.util.Map;
import java.util.UUID;

public interface RelationalStruct
extends Struct,
Wrapper {
    public StructMetaData getMetaData() throws SQLException;

    public boolean getBoolean(int var1) throws SQLException;

    public boolean getBoolean(String var1) throws SQLException;

    public int getInt(int var1) throws SQLException;

    public int getInt(String var1) throws SQLException;

    public long getLong(int var1) throws SQLException;

    public long getLong(String var1) throws SQLException;

    public float getFloat(int var1) throws SQLException;

    public float getFloat(String var1) throws SQLException;

    public double getDouble(int var1) throws SQLException;

    public double getDouble(String var1) throws SQLException;

    public byte[] getBytes(int var1) throws SQLException;

    public byte[] getBytes(String var1) throws SQLException;

    public String getString(int var1) throws SQLException;

    public String getString(String var1) throws SQLException;

    public Object getObject(int var1) throws SQLException;

    public Object getObject(String var1) throws SQLException;

    public RelationalStruct getStruct(int var1) throws SQLException;

    public RelationalStruct getStruct(String var1) throws SQLException;

    public RelationalArray getArray(int var1) throws SQLException;

    public RelationalArray getArray(String var1) throws SQLException;

    public UUID getUUID(int var1) throws SQLException;

    public UUID getUUID(String var1) throws SQLException;

    public boolean wasNull() throws SQLException;

    @Override
    default public String getSQLTypeName() throws SQLException {
        return "STRUCT";
    }

    @Override
    default public Object[] getAttributes() throws SQLException {
        StructMetaData metaData = this.getMetaData();
        Object[] arr = new Object[metaData.getColumnCount()];
        for (int i = 1; i <= arr.length; ++i) {
            arr[i - 1] = this.getObject(i);
        }
        return arr;
    }

    @Override
    default public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        StructMetaData metaData = this.getMetaData();
        Object[] arr = new Object[metaData.getColumnCount()];
        for (int i = 1; i <= arr.length; ++i) {
            Object o = this.getObject(i);
            if (o == null) {
                arr[i - 1] = null;
                continue;
            }
            String columnName = metaData.getColumnName(i);
            Class<Object> type = map.getOrDefault(columnName, Object.class);
            try {
                arr[i - 1] = type.cast(o);
                continue;
            }
            catch (ClassCastException cce) {
                throw new SQLException("Unable to cast column <" + columnName + "> to type <" + String.valueOf(type) + ">", ErrorCode.INVALID_PARAMETER.getErrorCode());
            }
        }
        return arr;
    }

    @Override
    default public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException("Unwrap failed for: " + String.valueOf(iface));
    }

    @Override
    default public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    public static int getOneBasedPosition(String columnName, RelationalStruct relationalStruct) throws SQLException {
        StructMetaData metaData = relationalStruct.getMetaData();
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            if (!metaData.getColumnName(i).equalsIgnoreCase(columnName)) continue;
            return i;
        }
        throw new InvalidColumnReferenceException(columnName).toSqlException();
    }
}

