/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.ArrayMetaData;
import com.apple.foundationdb.relational.api.RelationalArrayMetaData;
import com.apple.foundationdb.relational.api.SqlTypeNamesSupport;
import com.apple.foundationdb.relational.api.StructMetaData;
import com.apple.foundationdb.relational.api.exceptions.InvalidColumnReferenceException;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.util.ExcludeFromJacocoGeneratedReport;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class RelationalStructMetaData
implements StructMetaData {
    private static final Set<String> KNOWN_PHANTOM_COLUMNS = Set.of("__TYPE_KEY");
    @Nonnull
    private final DataType.StructType type;
    private final int leadingPhantomColumnOffset;
    private final Supplier<Integer> hashCodeSupplier;

    private RelationalStructMetaData(@Nonnull DataType.StructType type) {
        this.type = type;
        this.leadingPhantomColumnOffset = this.countLeadingPhantomColumns();
        this.hashCodeSupplier = Suppliers.memoize(this::calculateHashCode);
    }

    @Nonnull
    public static RelationalStructMetaData of(@Nonnull DataType.StructType type) {
        return new RelationalStructMetaData(type);
    }

    @Override
    public String getTypeName() {
        return this.type.getName();
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.type.getFields().size() - this.leadingPhantomColumnOffset;
    }

    @Override
    public int isNullable(int oneBasedColumn) throws SQLException {
        if (this.getField(oneBasedColumn).getType().isNullable()) {
            return 1;
        }
        return 0;
    }

    @Override
    public String getColumnLabel(int oneBasedColumn) throws SQLException {
        return this.getColumnName(oneBasedColumn);
    }

    @Override
    public String getColumnName(int oneBasedColumn) throws SQLException {
        return this.getField(oneBasedColumn).getName();
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public String getSchemaName(int oneBasedColumn) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not yet implemented");
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public String getTableName(int oneBasedColumn) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not yet implemented");
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public String getCatalogName(int oneBasedColumn) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not yet implemented");
    }

    @Override
    public int getColumnType(int oneBasedColumn) throws SQLException {
        return this.getField(oneBasedColumn).getType().getJdbcSqlCode();
    }

    @Override
    public String getColumnTypeName(int oneBasedColumn) throws SQLException {
        return SqlTypeNamesSupport.getSqlTypeName(this.getColumnType(oneBasedColumn));
    }

    @Override
    public StructMetaData getStructMetaData(int oneBasedColumn) throws SQLException {
        DataType type = this.getField(oneBasedColumn).getType();
        if (type.getCode() == DataType.Code.STRUCT) {
            return RelationalStructMetaData.of((DataType.StructType)type);
        }
        throw new InvalidColumnReferenceException("Position <" + oneBasedColumn + "> is not a struct type").toSqlException();
    }

    @Override
    public ArrayMetaData getArrayMetaData(int oneBasedColumn) throws SQLException {
        DataType type = this.getField(oneBasedColumn).getType();
        if (type.getCode() == DataType.Code.ARRAY) {
            return RelationalArrayMetaData.of((DataType.ArrayType)type);
        }
        throw new InvalidColumnReferenceException("Position <" + oneBasedColumn + "> is not an array type").toSqlException();
    }

    @Override
    public int getLeadingPhantomColumnCount() {
        return this.leadingPhantomColumnOffset;
    }

    @Override
    @Nonnull
    public DataType.StructType getRelationalDataType() throws SQLException {
        return this.type;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isAssignableFrom(this.getClass());
    }

    @Nonnull
    private List<DataType.StructType.Field> getFields() {
        return ImmutableList.copyOf(this.type.getFields());
    }

    private DataType.StructType.Field getField(int oneBasedColumn) throws SQLException {
        try {
            int adjustedColPosition = this.leadingPhantomColumnOffset + (oneBasedColumn - 1);
            return this.type.getFields().get(adjustedColPosition);
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            throw new InvalidColumnReferenceException("Position <" + oneBasedColumn + "> is not valid. Struct has " + this.getColumnCount() + " columns").toSqlException();
        }
    }

    private int countLeadingPhantomColumns() {
        List<DataType.StructType.Field> fields = this.getFields();
        int count = 0;
        for (DataType.StructType.Field field : fields) {
            if (!KNOWN_PHANTOM_COLUMNS.contains(field.getName())) {
                return count;
            }
            ++count;
        }
        return count;
    }

    public boolean equals(Object other) {
        if (!(other instanceof RelationalStructMetaData)) {
            return false;
        }
        RelationalStructMetaData otherMetadata = (RelationalStructMetaData)other;
        if (otherMetadata == this) {
            return true;
        }
        return this.leadingPhantomColumnOffset == otherMetadata.leadingPhantomColumnOffset && this.type.equals(otherMetadata.type);
    }

    public int hashCode() {
        return this.hashCodeSupplier.get();
    }

    private int calculateHashCode() {
        return Objects.hash(this.type, this.leadingPhantomColumnOffset);
    }
}

