/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.ArrayMetaData;
import com.apple.foundationdb.relational.api.EmbeddedRelationalArray;
import com.apple.foundationdb.relational.api.RelationalArray;
import com.apple.foundationdb.relational.api.RelationalResultSet;
import com.apple.foundationdb.relational.api.RelationalStructMetaData;
import com.apple.foundationdb.relational.api.Row;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.recordlayer.ArrayRow;
import com.apple.foundationdb.relational.recordlayer.IteratorResultSet;
import com.google.common.base.Suppliers;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class RowArray
implements RelationalArray,
EmbeddedRelationalArray {
    private final Supplier<List<Row>> rows;
    private final ArrayMetaData arrayMetaData;
    private final Supplier<Integer> hashCodeSupplier;

    public RowArray(@Nonnull List<?> elements, @Nonnull ArrayMetaData arrayMetaData) {
        this.arrayMetaData = arrayMetaData;
        this.rows = Suppliers.memoize(() -> RowArray.createIterableRows(elements));
        this.hashCodeSupplier = Suppliers.memoize(this::calculateHashCode);
    }

    private static List<Row> createIterableRows(@Nonnull List<?> elements) {
        int i = 1;
        ArrayList<Row> rows = new ArrayList<Row>();
        for (Object element : elements) {
            rows.add(new ArrayRow(i++, element));
        }
        return rows;
    }

    @Override
    public RelationalResultSet getResultSet(long oneBasedIndex, int count) throws SQLException {
        List slice = this.rows.get().stream().skip(oneBasedIndex - 1L).limit(count).collect(Collectors.toList());
        DataType.StructType type = DataType.StructType.from("ARRAY_ROW", List.of(DataType.StructType.Field.from("INDEX", DataType.Primitives.INTEGER.type(), 0), DataType.StructType.Field.from("VALUE", this.arrayMetaData.asRelationalType().getElementType(), 1)), true);
        return new IteratorResultSet(RelationalStructMetaData.of(type), slice.iterator(), 0);
    }

    @Override
    public int getBaseType() throws SQLException {
        return this.arrayMetaData.getElementType();
    }

    @Override
    @Nonnull
    public ArrayMetaData getMetaData() throws SQLException {
        return this.arrayMetaData;
    }

    public String toString() {
        return this.rows.get().stream().map(Objects::toString).collect(Collectors.joining(",", "[", "]"));
    }

    public boolean equals(Object other) {
        if (!(other instanceof RowArray)) {
            return false;
        }
        RowArray otherArrayRow = (RowArray)other;
        if (otherArrayRow == this) {
            return true;
        }
        if (!this.arrayMetaData.equals(otherArrayRow.arrayMetaData)) {
            return false;
        }
        Iterator<Row> iterator = this.rows.get().iterator();
        Iterator<Row> otherIterator = otherArrayRow.rows.get().iterator();
        while (iterator.hasNext()) {
            if (otherIterator.hasNext() && iterator.next().equals(otherIterator.next())) continue;
            return false;
        }
        return otherIterator.hasNext();
    }

    public int hashCode() {
        return this.hashCodeSupplier.get();
    }

    private int calculateHashCode() {
        return Objects.hash(Arrays.hashCode(this.rows.get().toArray()), this.arrayMetaData);
    }
}

