/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api;

import com.apple.foundationdb.relational.api.ArrayMetaData;
import com.apple.foundationdb.relational.api.EmbeddedRelationalStruct;
import com.apple.foundationdb.relational.api.ImmutableRowStruct;
import com.apple.foundationdb.relational.api.RelationalArray;
import com.apple.foundationdb.relational.api.RelationalStruct;
import com.apple.foundationdb.relational.api.Row;
import com.apple.foundationdb.relational.api.RowArray;
import com.apple.foundationdb.relational.api.StructMetaData;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.InvalidColumnReferenceException;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.exceptions.UncheckedRelationalException;
import com.apple.foundationdb.relational.recordlayer.ArrayRow;
import com.apple.foundationdb.relational.recordlayer.MessageTuple;
import com.apple.foundationdb.relational.util.Assert;
import com.apple.foundationdb.relational.util.NullableArrayUtils;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.UUID;

public abstract class RowStruct
implements RelationalStruct,
EmbeddedRelationalStruct {
    private final StructMetaData metaData;
    protected boolean wasNull;

    protected RowStruct(StructMetaData metaData) {
        this.metaData = metaData;
    }

    @Override
    public StructMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    @Override
    public boolean getBoolean(int oneBasedPosition) throws SQLException {
        Object o = this.getObjectInternal(this.getZeroBasedPosition(oneBasedPosition));
        if (o == null) {
            return false;
        }
        if (!(o instanceof Boolean)) {
            throw new SQLException("Boolean", ErrorCode.CANNOT_CONVERT_TYPE.getErrorCode());
        }
        return (Boolean)o;
    }

    protected abstract Object getObjectInternal(int var1) throws SQLException;

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.getOneBasedPosition(columnLabel));
    }

    @Override
    public byte[] getBytes(int oneBasedPosition) throws SQLException {
        Object o = this.getObjectInternal(this.getZeroBasedPosition(oneBasedPosition));
        if (o == null) {
            return null;
        }
        if (o instanceof ByteString) {
            return ((ByteString)o).toByteArray();
        }
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        throw new SQLException("byte[]", ErrorCode.CANNOT_CONVERT_TYPE.getErrorCode());
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.getOneBasedPosition(columnLabel));
    }

    @Override
    public int getInt(int oneBasedPosition) throws SQLException {
        Object o = this.getObjectInternal(this.getZeroBasedPosition(oneBasedPosition));
        if (o == null) {
            return 0;
        }
        if (!(o instanceof Number)) {
            throw new SQLException(String.format(Locale.ROOT, "Cannot convert %s to Integer", o.getClass().toString()), ErrorCode.CANNOT_CONVERT_TYPE.getErrorCode());
        }
        return ((Number)o).intValue();
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.getOneBasedPosition(columnLabel));
    }

    @Override
    public long getLong(int oneBasedPosition) throws SQLException {
        Object o = this.getObjectInternal(this.getZeroBasedPosition(oneBasedPosition));
        if (o == null) {
            return 0L;
        }
        if (!(o instanceof Number)) {
            throw new SQLException(String.format(Locale.ROOT, "Cannot convert %s to Long", o.getClass().toString()), ErrorCode.CANNOT_CONVERT_TYPE.getErrorCode());
        }
        return ((Number)o).longValue();
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.getOneBasedPosition(columnLabel));
    }

    @Override
    public float getFloat(int oneBasedPosition) throws SQLException {
        Object o = this.getObjectInternal(this.getZeroBasedPosition(oneBasedPosition));
        if (o == null) {
            return 0.0f;
        }
        if (!(o instanceof Number)) {
            throw new SQLException("Float", ErrorCode.CANNOT_CONVERT_TYPE.getErrorCode());
        }
        return ((Number)o).floatValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.getOneBasedPosition(columnLabel));
    }

    @Override
    public double getDouble(int oneBasedPosition) throws SQLException {
        Object o = this.getObjectInternal(this.getZeroBasedPosition(oneBasedPosition));
        if (o == null) {
            return 0.0;
        }
        if (!(o instanceof Number)) {
            throw new SQLException("Double", ErrorCode.CANNOT_CONVERT_TYPE.getErrorCode());
        }
        return ((Number)o).doubleValue();
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.getOneBasedPosition(columnLabel));
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.getOneBasedPosition(columnLabel));
    }

    @Override
    public Object getObject(int oneBasedPosition) throws SQLException {
        switch (this.metaData.getColumnType(oneBasedPosition)) {
            case 2002: {
                return this.getStruct(oneBasedPosition);
            }
            case 2003: {
                return this.getArray(oneBasedPosition);
            }
            case -2: {
                return this.getBytes(oneBasedPosition);
            }
        }
        return this.getObjectInternal(this.getZeroBasedPosition(oneBasedPosition));
    }

    @Override
    public String getString(int oneBasedPosition) throws SQLException {
        Object o = this.getObjectInternal(this.getZeroBasedPosition(oneBasedPosition));
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Number) {
            return o.toString();
        }
        if (o instanceof URI) {
            return o.toString();
        }
        if (o instanceof Enum) {
            return ((Enum)o).name();
        }
        if (o instanceof Descriptors.EnumValueDescriptor) {
            return ((Descriptors.EnumValueDescriptor)o).getName();
        }
        if (o instanceof ByteString) {
            return ((ByteString)o).toString();
        }
        throw new SQLException("String", ErrorCode.CANNOT_CONVERT_TYPE.getErrorCode());
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.getOneBasedPosition(columnLabel));
    }

    @Override
    public RelationalArray getArray(int oneBasedPosition) throws SQLException {
        if (this.metaData.getColumnType(oneBasedPosition) != 2003) {
            throw new SQLException("Array", ErrorCode.CANNOT_CONVERT_TYPE.getErrorCode());
        }
        Object obj = this.getObjectInternal(this.getZeroBasedPosition(oneBasedPosition));
        if (obj == null) {
            return null;
        }
        if (obj instanceof RelationalArray) {
            return (RelationalArray)obj;
        }
        if (obj instanceof Collection) {
            Collection coll = (Collection)obj;
            ArrayMetaData arrayMetaData = this.metaData.getArrayMetaData(oneBasedPosition);
            ArrayList<ImmutableRowStruct> elements = new ArrayList<ImmutableRowStruct>();
            for (Object t2 : coll) {
                if (t2 instanceof Message) {
                    elements.add(new ImmutableRowStruct(new MessageTuple((Message)t2), arrayMetaData.getElementStructMetaData()));
                    continue;
                }
                elements.add((ImmutableRowStruct)t2);
            }
            return new RowArray(elements, arrayMetaData);
        }
        if (obj instanceof Message) {
            Message message = (Message)obj;
            ArrayMetaData arrayMetaData = this.metaData.getArrayMetaData(oneBasedPosition);
            if (!NullableArrayUtils.isWrappedArrayDescriptor(message.getDescriptorForType())) {
                throw new SQLException("Array", ErrorCode.CANNOT_CONVERT_TYPE.getErrorCode());
            }
            Descriptors.FieldDescriptor fieldDescriptor = message.getDescriptorForType().findFieldByName(NullableArrayUtils.getRepeatedFieldName());
            Collection fieldValues = (Collection)message.getField(fieldDescriptor);
            ArrayList<Object> elements = new ArrayList<Object>();
            for (Object fieldValue : fieldValues) {
                Object sanitizedFieldValue = MessageTuple.sanitizeField(fieldValue);
                if (sanitizedFieldValue instanceof Message) {
                    elements.add(new ImmutableRowStruct(new MessageTuple((Message)sanitizedFieldValue), arrayMetaData.getElementStructMetaData()));
                    continue;
                }
                elements.add(sanitizedFieldValue);
            }
            return new RowArray(elements, arrayMetaData);
        }
        throw new SQLException("Array", ErrorCode.CANNOT_CONVERT_TYPE.getErrorCode());
    }

    @Override
    public RelationalArray getArray(String columnLabel) throws SQLException {
        return this.getArray(this.getOneBasedPosition(columnLabel));
    }

    @Override
    public RelationalStruct getStruct(int oneBasedColumn) throws SQLException {
        if (this.metaData.getColumnType(oneBasedColumn) != 2002) {
            throw new SQLException("Struct", ErrorCode.CANNOT_CONVERT_TYPE.getErrorCode());
        }
        Object obj = this.getObjectInternal(this.getZeroBasedPosition(oneBasedColumn));
        if (obj == null) {
            return null;
        }
        if (obj instanceof RelationalStruct) {
            return (RelationalStruct)obj;
        }
        if (obj instanceof Row) {
            return new ImmutableRowStruct((Row)obj, this.metaData.getStructMetaData(oneBasedColumn));
        }
        if (obj instanceof Message) {
            return new ImmutableRowStruct(new MessageTuple((Message)obj), this.metaData.getStructMetaData(oneBasedColumn));
        }
        if (obj instanceof UUID) {
            UUID uuid = (UUID)obj;
            return new ImmutableRowStruct(new ArrayRow(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()), this.metaData.getStructMetaData(oneBasedColumn));
        }
        throw new SQLException("Struct", ErrorCode.CANNOT_CONVERT_TYPE.getErrorCode());
    }

    @Override
    public UUID getUUID(String columnLabel) throws SQLException {
        return this.getUUID(this.getOneBasedPosition(columnLabel));
    }

    @Override
    public UUID getUUID(int oneBasedColumn) throws SQLException {
        if (this.metaData.getColumnType(oneBasedColumn) != 1111) {
            throw new SQLException("Expected UUID should have type OTHER", ErrorCode.CANNOT_CONVERT_TYPE.getErrorCode());
        }
        Object obj = this.getObjectInternal(this.getZeroBasedPosition(oneBasedColumn));
        if (obj == null) {
            return null;
        }
        Assert.thatUnchecked(obj instanceof UUID, ErrorCode.CANNOT_CONVERT_TYPE, "Expected UUID, got {}", obj.getClass().getName());
        return (UUID)obj;
    }

    @Override
    public RelationalStruct getStruct(String columnLabel) throws SQLException {
        return this.getStruct(this.getOneBasedPosition(columnLabel));
    }

    private int getOneBasedPosition(String columnLabel) throws SQLException {
        for (int pos = 1; pos <= this.metaData.getColumnCount(); ++pos) {
            if (!this.metaData.getColumnName(pos).equalsIgnoreCase(columnLabel)) continue;
            return pos;
        }
        throw new InvalidColumnReferenceException("Invalid column: " + columnLabel).toSqlException();
    }

    private int getZeroBasedPosition(int oneBasedPosition) {
        return this.metaData.getLeadingPhantomColumnCount() + oneBasedPosition - 1;
    }

    public String toString() {
        boolean preservedWasNullValue = this.wasNull();
        StringBuilder builder = new StringBuilder();
        try {
            int colCount = this.metaData.getColumnCount();
            builder.append("{ ");
            for (int i = 1; i <= colCount; ++i) {
                builder.append(this.metaData.getColumnName(i)).append(" -> ").append(this.getObject(i)).append("\n");
                if (i >= colCount) continue;
                builder.append(", ");
            }
            builder.append("} ");
        }
        catch (SQLException e) {
            throw new UncheckedRelationalException(new RelationalException(e));
        }
        finally {
            this.wasNull = preservedWasNullValue;
        }
        return builder.toString();
    }
}

