/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.metadata.DataType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public final class SqlTypeNamesSupport {
    private SqlTypeNamesSupport() {
    }

    public static String getSqlTypeName(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 12: {
                return "STRING";
            }
            case 2002: {
                return "STRUCT";
            }
            case 2003: {
                return "ARRAY";
            }
            case -2: {
                return "BINARY";
            }
            case 0: {
                return "NULL";
            }
            case 1111: {
                return "OTHER";
            }
            case 16: {
                return "BOOLEAN";
            }
        }
        throw new IllegalStateException("Unexpected sql type code :" + sqlTypeCode);
    }

    public static int getSqlTypeCode(String sqlTypeName) {
        switch (sqlTypeName) {
            case "INTEGER": {
                return 4;
            }
            case "BINARY": {
                return -2;
            }
            case "BIGINT": {
                return -5;
            }
            case "FLOAT": {
                return 6;
            }
            case "DOUBLE": {
                return 8;
            }
            case "STRING": {
                return 12;
            }
            case "STRUCT": {
                return 2002;
            }
            case "ARRAY": {
                return 2003;
            }
            case "NULL": {
                return 0;
            }
            case "BOOLEAN": {
                return 16;
            }
        }
        throw new IllegalStateException("Unexpected sql type name:" + sqlTypeName);
    }

    @Nullable
    public static DataType getDataTypeFromSqlTypeName(@Nonnull String sqlTypeName) {
        switch (sqlTypeName) {
            case "INTEGER": {
                return DataType.Primitives.INTEGER.type();
            }
            case "BINARY": {
                return DataType.Primitives.BYTES.type();
            }
            case "BIGINT": {
                return DataType.Primitives.LONG.type();
            }
            case "FLOAT": {
                return DataType.Primitives.FLOAT.type();
            }
            case "DOUBLE": {
                return DataType.Primitives.DOUBLE.type();
            }
            case "STRING": {
                return DataType.Primitives.STRING.type();
            }
            case "BOOLEAN": {
                return DataType.Primitives.BOOLEAN.type();
            }
            case "NULL": {
                return DataType.Primitives.NULL.type();
            }
        }
        return null;
    }
}

