/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api;

import com.apple.foundationdb.relational.api.exceptions.InternalErrorException;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.SchemaTemplate;
import java.util.Optional;
import javax.annotation.Nonnull;

public interface Transaction
extends AutoCloseable {
    public void commit() throws RelationalException;

    public void abort() throws RelationalException;

    @Nonnull
    public Optional<SchemaTemplate> getBoundSchemaTemplateMaybe();

    public void setBoundSchemaTemplate(@Nonnull SchemaTemplate var1);

    public void unsetBoundSchemaTemplate();

    @Override
    public void close() throws RelationalException;

    public boolean isClosed();

    @Nonnull
    default public <T> T unwrap(@Nonnull Class<? extends T> type) throws InternalErrorException {
        Class<? extends T> myClass = this.getClass();
        if (myClass.isAssignableFrom(type)) {
            return type.cast(this);
        }
        throw new InternalErrorException("Cannot unwrap instance of type <" + myClass.getCanonicalName() + "> as type <" + type.getCanonicalName() + ">");
    }
}

