/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.catalog;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.Schema;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public final class CatalogValidator {
    public static void validateSchema(@Nonnull Schema schema) throws RelationalException {
        if (schema.getName() == null || schema.getName().isEmpty()) {
            throw new RelationalException("Field schema_name in Schema must be set!", ErrorCode.INVALID_PARAMETER);
        }
        if (schema.getDatabaseName() == null || schema.getDatabaseName().isEmpty()) {
            throw new RelationalException("Field database_id in Schema must be set!", ErrorCode.INVALID_PARAMETER);
        }
        if (schema.getSchemaTemplate().getName() == null || schema.getSchemaTemplate().getName().isEmpty()) {
            throw new RelationalException("Field schema_template_name in Schema must be set!", ErrorCode.INVALID_PARAMETER);
        }
        if (schema.getSchemaTemplate().getVersion() < 0) {
            throw new RelationalException("Field schema_version cannot be < 0!", ErrorCode.INVALID_PARAMETER);
        }
    }

    private CatalogValidator() {
    }
}

