/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.ddl;

import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.relational.api.RelationalResultSet;
import com.apple.foundationdb.relational.api.Transaction;
import com.apple.foundationdb.relational.api.catalog.StoreCatalog;
import com.apple.foundationdb.relational.api.ddl.DdlQuery;
import com.apple.foundationdb.relational.api.ddl.DdlQueryFactory;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.metadata.Metadata;
import com.apple.foundationdb.relational.recordlayer.ContinuationImpl;
import com.apple.foundationdb.relational.recordlayer.catalog.systables.SystemTableRegistry;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public abstract class CatalogQueryFactory
implements DdlQueryFactory {
    protected final StoreCatalog catalog;

    public CatalogQueryFactory(StoreCatalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public DdlQuery getListDatabasesQueryAction(@Nonnull URI prefixPath) {
        return new DdlQuery(){

            @Override
            @Nonnull
            public Type getResultSetMetadata() {
                List<String> fieldNames = SystemTableRegistry.getSystemTable("DATABASES").getType().getColumns().stream().map(Metadata::getName).collect(Collectors.toList());
                return DdlQuery.constructTypeFrom(fieldNames);
            }

            @Override
            public RelationalResultSet executeAction(Transaction txn) throws RelationalException {
                return CatalogQueryFactory.this.catalog.listDatabases(txn, ContinuationImpl.BEGIN);
            }
        };
    }

    @Override
    public DdlQuery getListSchemaTemplatesQueryAction() {
        final List<String> columns = List.of("TEMPLATE_NAME");
        return new DdlQuery(){

            @Override
            @Nonnull
            public Type getResultSetMetadata() {
                return DdlQuery.constructTypeFrom(columns);
            }

            @Override
            public RelationalResultSet executeAction(Transaction txn) throws RelationalException {
                return CatalogQueryFactory.this.catalog.getSchemaTemplateCatalog().listTemplates(txn);
            }
        };
    }
}

