/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.ddl;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.query.plan.cascades.typing.Type;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;

@API(value=API.Status.EXPERIMENTAL)
public final class ProtobufDdlUtil {
    private ProtobufDdlUtil() {
    }

    public static Type.Record recordFromDescriptor(Descriptors.Descriptor descriptor) throws RelationalException {
        Map descriptorLookupMap = descriptor.getFields().stream().collect(Collectors.toMap(Descriptors.FieldDescriptor::getName, Function.identity()));
        TreeMap<String, Descriptors.FieldDescriptor> orderedFieldMap = new TreeMap<String, Descriptors.FieldDescriptor>((o1, o2) -> {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            Descriptors.FieldDescriptor field1 = (Descriptors.FieldDescriptor)descriptorLookupMap.get(o1);
            Descriptors.FieldDescriptor field2 = (Descriptors.FieldDescriptor)descriptorLookupMap.get(o2);
            return Integer.compare(field1.getIndex(), field2.getIndex());
        });
        orderedFieldMap.putAll(descriptorLookupMap);
        return Type.Record.fromFieldDescriptorsMap(orderedFieldMap);
    }

    public static String getTypeName(DescriptorProtos.FieldDescriptorProto descriptor) {
        Object type = "";
        switch (descriptor.getType()) {
            case TYPE_INT32: {
                type = (String)type + "INTEGER";
                break;
            }
            case TYPE_INT64: {
                type = (String)type + "BIGINT";
                break;
            }
            case TYPE_FLOAT: {
                type = (String)type + "FLOAT";
                break;
            }
            case TYPE_DOUBLE: {
                type = (String)type + "DOUBLE";
                break;
            }
            case TYPE_BOOL: {
                type = (String)type + "BOOLEAN";
                break;
            }
            case TYPE_STRING: {
                type = (String)type + "STRING";
                break;
            }
            case TYPE_BYTES: {
                type = (String)type + "BYTES";
                break;
            }
            case TYPE_MESSAGE: 
            case TYPE_ENUM: {
                type = (String)type + descriptor.getTypeName();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected descriptor java type <" + String.valueOf(descriptor.getType()));
            }
        }
        if (descriptor.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED) {
            type = (String)type + " array";
        }
        return type;
    }

    public static String getTypeName(Descriptors.FieldDescriptor descriptor) {
        Object type = "";
        switch (descriptor.getJavaType()) {
            case INT: {
                type = (String)type + "INTEGER";
                break;
            }
            case LONG: {
                type = (String)type + "BIGINT";
                break;
            }
            case FLOAT: {
                type = (String)type + "FLOAT";
                break;
            }
            case DOUBLE: {
                type = (String)type + "DOUBLE";
                break;
            }
            case BOOLEAN: {
                type = (String)type + "BOOLEAN";
                break;
            }
            case STRING: {
                type = (String)type + "STRING";
                break;
            }
            case BYTE_STRING: {
                type = (String)type + "BYTES";
                break;
            }
            case MESSAGE: {
                type = (String)type + descriptor.getMessageType().getName();
                break;
            }
            case ENUM: {
                type = (String)type + descriptor.getEnumType().getName();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected java type :" + String.valueOf((Object)descriptor.getJavaType()));
            }
        }
        if (descriptor.isRepeated()) {
            type = (String)type + " array";
        }
        return ((String)type).toUpperCase(Locale.ROOT);
    }

    public static int getSqlType(Descriptors.FieldDescriptor field) {
        if (field.isRepeated()) {
            return 2003;
        }
        switch (field.getJavaType()) {
            case INT: {
                return 4;
            }
            case LONG: {
                return -5;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 8;
            }
            case BOOLEAN: {
                return 16;
            }
            case STRING: {
                return 12;
            }
            case BYTE_STRING: {
                return -3;
            }
            case MESSAGE: {
                return 2002;
            }
        }
        throw new IllegalStateException("Unexpected java type " + String.valueOf((Object)field.getJavaType()));
    }

    public static Type.Record recordFromFieldDescriptors(List<Descriptors.FieldDescriptor> fields) {
        Map descriptorLookupMap = fields.stream().collect(Collectors.toMap(Descriptors.FieldDescriptor::getName, Function.identity()));
        TreeMap<String, Descriptors.FieldDescriptor> orderedFieldMap = new TreeMap<String, Descriptors.FieldDescriptor>((o1, o2) -> {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            Descriptors.FieldDescriptor field1 = (Descriptors.FieldDescriptor)descriptorLookupMap.get(o1);
            Descriptors.FieldDescriptor field2 = (Descriptors.FieldDescriptor)descriptorLookupMap.get(o2);
            return Integer.compare(field1.getIndex(), field2.getIndex());
        });
        orderedFieldMap.putAll(descriptorLookupMap);
        return Type.Record.fromFields(Type.Record.fromFieldDescriptorsMap(orderedFieldMap).getFields().stream().map(f -> Type.Record.Field.of(f.getFieldType(), f.getFieldNameOptional())).collect(Collectors.toList()));
    }
}

