/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.exceptions;

import com.apple.foundationdb.annotation.API;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@API(value=API.Status.EXPERIMENTAL)
public class ContextualSQLException
extends SQLException {
    private static final long serialVersionUID = 2135244094396331484L;
    @Nonnull
    private final Map<String, Object> context;

    public ContextualSQLException(String reason, String SQLState, int vendorCode) {
        super(reason, SQLState, vendorCode);
        this.context = Collections.emptyMap();
    }

    public ContextualSQLException(String reason, String SQLState) {
        super(reason, SQLState);
        this.context = Collections.emptyMap();
    }

    public ContextualSQLException(String reason) {
        super(reason);
        this.context = Collections.emptyMap();
    }

    public ContextualSQLException() {
        this.context = Collections.emptyMap();
    }

    public ContextualSQLException(Throwable cause) {
        super(cause);
        this.context = Collections.emptyMap();
    }

    public ContextualSQLException(String reason, Throwable cause) {
        super(reason, cause);
        this.context = Collections.emptyMap();
    }

    public ContextualSQLException(String reason, String sqlState, Throwable cause, @Nullable Map<String, Object> extraContext) {
        super(reason, sqlState, cause);
        this.context = extraContext != null ? Collections.unmodifiableMap(new HashMap<String, Object>(extraContext)) : Collections.emptyMap();
    }

    public ContextualSQLException(String reason, String sqlState, int vendorCode, Throwable cause) {
        super(reason, sqlState, vendorCode, cause);
        this.context = Collections.emptyMap();
    }

    public Map<String, Object> getContext() {
        return this.context;
    }
}

