/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.exceptions;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ErrorCode {
    SUCCESS("00000"),
    NO_RESULT_SET("02F01"),
    UNABLE_TO_ESTABLISH_SQL_CONNECTION("08001"),
    CONNECTION_DOES_NOT_EXIST("08003"),
    INVALID_PATH("08F01"),
    CANNOT_COMMIT_ROLLBACK_WITH_AUTOCOMMIT("08F02"),
    UNSUPPORTED_OPERATION("0A000"),
    UNSUPPORTED_QUERY("0AF00"),
    CANNOT_CONVERT_TYPE("22000"),
    INVALID_ROW_COUNT_IN_LIMIT_CLAUSE("2201W"),
    INVALID_PARAMETER("22023"),
    ARRAY_ELEMENT_ERROR("2202E"),
    INVALID_BINARY_REPRESENTATION("22F03"),
    INVALID_ARGUMENT_FOR_FUNCTION("22F00"),
    NOT_NULL_VIOLATION("23502"),
    UNIQUE_CONSTRAINT_VIOLATION("23505"),
    INVALID_CURSOR_STATE("24000"),
    INVALID_CONTINUATION("24F00"),
    INVALID_TRANSACTION_STATE("25000"),
    TRANSACTION_INACTIVE("25F01"),
    SERIALIZATION_FAILURE("40001"),
    SYNTAX_OR_ACCESS_VIOLATION("42000"),
    INSUFFICIENT_PRIVILEGE("42501"),
    SYNTAX_ERROR("42601"),
    INVALID_NAME("42602"),
    COLUMN_ALREADY_EXISTS("42701"),
    AMBIGUOUS_COLUMN("42702"),
    UNDEFINED_COLUMN("42703"),
    DUPLICATE_ALIAS("42712"),
    DUPLICATE_FUNCTION("42723"),
    GROUPING_ERROR("42803"),
    DATATYPE_MISMATCH("42804"),
    WRONG_OBJECT_TYPE("42809"),
    UNDEFINED_FUNCTION("42883"),
    UNDEFINED_DATABASE("42F00"),
    UNDEFINED_TABLE("42F01"),
    UNDEFINED_PARAMETER("42F02"),
    DATABASE_ALREADY_EXISTS("42F04"),
    SCHEMA_ALREADY_EXISTS("42F06"),
    TABLE_ALREADY_EXISTS("42F07"),
    INVALID_COLUMN_REFERENCE("42F10"),
    INVALID_FUNCTION_DEFINITION("42F13"),
    INVALID_TABLE_DEFINITION("42F16"),
    UNKNOWN_TYPE("42F18"),
    INVALID_RECURSION("42F19"),
    INCOMPATIBLE_TABLE_ALIAS("42F20"),
    SCHEMA_MAPPING_ALREADY_EXISTS("42F50"),
    UNDEFINED_SCHEMA("42F51"),
    UNDEFINED_INDEX("42F54"),
    UNKNOWN_SCHEMA_TEMPLATE("42F55"),
    ANNOTATION_ALREADY_EXISTS("42F56"),
    INDEX_ALREADY_EXISTS("42F57"),
    INCORRECT_METADATA_TABLE_VERSION("42F58"),
    INVALID_SCHEMA_TEMPLATE("42F59"),
    INVALID_PREPARED_STATEMENT_PARAMETER("42F60"),
    EXECUTE_UPDATE_RETURNED_RESULT_SET("42F61"),
    DUPLICATE_SCHEMA_TEMPLATE("42F62"),
    UNKNOWN_DATABASE("42F63"),
    UNION_INCORRECT_COLUMN_COUNT("42F64"),
    UNION_INCOMPATIBLE_COLUMNS("42F65"),
    INVALID_DATABASE("42F66"),
    TRANSACTION_TIMEOUT("53F00"),
    TOO_MANY_COLUMNS("54011"),
    EXECUTION_LIMIT_REACHED("54F01"),
    STATEMENT_CLOSED("55F00"),
    UNDEFINED_FILE("58F01"),
    UNKNOWN("XXXXX"),
    INTERNAL_ERROR("XX000"),
    DESERIALIZATION_FAILURE("XXF01");

    private final String errorCode;
    private static final Map<String, ErrorCode> ENUM_MAP;

    private ErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public static ErrorCode get(String errorCode) {
        if (errorCode == null) {
            return UNKNOWN;
        }
        return ENUM_MAP.getOrDefault(errorCode, UNKNOWN);
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    static {
        ENUM_MAP = Stream.of(ErrorCode.values()).collect(Collectors.toUnmodifiableMap(ErrorCode::getErrorCode, Function.identity()));
    }
}

