/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.exceptions;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.exceptions.ContextualSQLException;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.UncheckedRelationalException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class RelationalException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final ErrorCode errorCode;
    private Map<String, Object> errorContext;

    public RelationalException(String message, ErrorCode errorCode) {
        super(message);
        this.errorCode = errorCode;
    }

    public RelationalException(String message, ErrorCode errorCode, Throwable cause) {
        super(message, cause);
        this.errorCode = errorCode;
    }

    public RelationalException(ErrorCode errorCode, Throwable cause) {
        super(cause);
        this.errorCode = errorCode;
    }

    public RelationalException(SQLException sqle) {
        super(sqle.getMessage(), sqle);
        this.errorCode = ErrorCode.get(sqle.getSQLState());
    }

    public RelationalException(String message, SQLException sqle) {
        super(message, sqle);
        this.errorCode = ErrorCode.get(sqle.getSQLState());
    }

    public SQLException toSqlException() {
        if (this.getCause() instanceof SQLException) {
            return (SQLException)this.getCause();
        }
        return new ContextualSQLException(this.getMessage(), this.getErrorCode().getErrorCode(), this, this.errorContext);
    }

    public RelationalException addContext(String ctxName, Object ctxValue) {
        if (this.errorContext == null) {
            this.errorContext = new HashMap<String, Object>();
        }
        this.errorContext.put(ctxName, ctxValue);
        return this;
    }

    public RelationalException withContext(@Nonnull Map<String, Object> context) {
        if (this.errorContext == null) {
            this.errorContext = new HashMap<String, Object>();
        }
        this.errorContext.putAll(context);
        return this;
    }

    public UncheckedRelationalException toUncheckedWrappedException() {
        return new UncheckedRelationalException(this);
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public Map<String, Object> getContext() {
        Map<String, Object> ret = this.errorContext;
        ret = ret == null ? Collections.emptyMap() : Collections.unmodifiableMap(ret);
        return ret;
    }
}

