/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.fluentsql;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.exceptions.ErrorCode;
import com.apple.foundationdb.relational.api.exceptions.RelationalException;
import com.apple.foundationdb.relational.api.fluentsql.FluentVisitor;
import com.apple.foundationdb.relational.api.fluentsql.expression.BooleanFunction;
import com.apple.foundationdb.relational.api.fluentsql.expression.BooleanLiteral;
import com.apple.foundationdb.relational.api.fluentsql.expression.ComparableFunction;
import com.apple.foundationdb.relational.api.fluentsql.expression.Expression;
import com.apple.foundationdb.relational.api.fluentsql.expression.ExpressionFragment;
import com.apple.foundationdb.relational.api.fluentsql.expression.Field;
import com.apple.foundationdb.relational.api.fluentsql.expression.FunctionLike;
import com.apple.foundationdb.relational.api.fluentsql.expression.NestedBooleanExpression;
import com.apple.foundationdb.relational.api.fluentsql.expression.NumericFunction;
import com.apple.foundationdb.relational.api.fluentsql.expression.NumericLiteral;
import com.apple.foundationdb.relational.api.fluentsql.expression.Operation;
import com.apple.foundationdb.relational.api.fluentsql.expression.StringLiteral;
import com.apple.foundationdb.relational.api.fluentsql.expression.UserDefinedField;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@API(value=API.Status.EXPERIMENTAL)
public class SqlVisitor
implements FluentVisitor<Void, StringBuilder> {
    private static final Map<Operation, String> operationSqlSymbols = ImmutableMap.builder().put(Operation.EQUAL, "=").put(Operation.NOT_EQUAL, "<>").put(Operation.IS_NULL, "IS NULL").put(Operation.IS_NOT_NULL, "IS NOT NULL").put(Operation.GREATER_THAN, ">").put(Operation.LESS_THAN, "<").put(Operation.GREATER_THAN_EQUALS, ">=").put(Operation.LESS_THAN_EQUALS, "<=").put(Operation.AND, "AND").put(Operation.OR, "OR").put(Operation.NOT, "NOT").put(Operation.ADD, "+").put(Operation.DIV, "/").put(Operation.MUL, "*").put(Operation.SUB, "-").put(Operation.MOD, "MOD").put(Operation.GREATEST, "GREATEST").put(Operation.JAVA_CALL, "JAVA_CALL").build();

    @Override
    @Nullable
    public Void visit(@Nonnull BooleanFunction booleanFunction, @Nonnull StringBuilder context) {
        return this.visit((FunctionLike<?>)booleanFunction, context);
    }

    @Override
    @Nullable
    public Void visit(@Nonnull NumericFunction<?> numericFunction, @Nonnull StringBuilder context) {
        return this.visit((FunctionLike<?>)numericFunction, context);
    }

    @Override
    @Nullable
    public Void visit(@Nonnull ComparableFunction<?, ?> comparableFunction, @Nonnull StringBuilder context) {
        return this.visit((FunctionLike<?>)comparableFunction, context);
    }

    @Override
    @Nullable
    public Void visit(@Nonnull FunctionLike<?> function, @Nonnull StringBuilder context) {
        switch (function.getName()) {
            case JAVA_CALL: 
            case GREATEST: {
                context.append(operationSqlSymbols.get((Object)function.getName())).append("(");
                int size = Iterables.size(function.getArguments());
                int cnt = 0;
                for (Expression<?> argument : function.getArguments()) {
                    argument.accept(this, context);
                    if (cnt < size - 1) {
                        context.append(",");
                    }
                    ++cnt;
                }
                context.append(")");
                break;
            }
            case EQUAL: 
            case NOT_EQUAL: 
            case GREATER_THAN: 
            case LESS_THAN: 
            case GREATER_THAN_EQUALS: 
            case LESS_THAN_EQUALS: 
            case AND: 
            case OR: 
            case NOT: 
            case ADD: 
            case DIV: 
            case MUL: 
            case SUB: 
            case MOD: {
                int size = Iterables.size(function.getArguments());
                int cnt = 0;
                for (Expression<?> argument : function.getArguments()) {
                    argument.accept(this, context);
                    if (cnt < size - 1) {
                        context.append(" ").append(operationSqlSymbols.get((Object)function.getName())).append(" ");
                    }
                    ++cnt;
                }
                break;
            }
            case IS_NULL: 
            case IS_NOT_NULL: {
                Iterables.getOnlyElement(function.getArguments()).accept(this, context);
                context.append(" ").append(operationSqlSymbols.get((Object)function.getName()));
                break;
            }
            default: {
                throw new RelationalException("unknown symbol '" + String.valueOf((Object)function.getName()) + "'", ErrorCode.INTERNAL_ERROR).toUncheckedWrappedException();
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Void visit(@Nonnull BooleanLiteral booleanLiteral, @Nonnull StringBuilder context) {
        context.append(booleanLiteral.getValue());
        return null;
    }

    @Override
    @Nullable
    public Void visit(@Nonnull NestedBooleanExpression expression, @Nonnull StringBuilder context) {
        context.append("( ");
        expression.getValue().accept(this, context);
        context.append(" )");
        return null;
    }

    @Override
    @Nullable
    public Void visit(@Nonnull NumericLiteral<?, ?> numericLiteral, @Nonnull StringBuilder context) {
        context.append(numericLiteral.getValue());
        return null;
    }

    @Override
    @Nullable
    public Void visit(@Nonnull StringLiteral stringLiteral, @Nonnull StringBuilder context) {
        context.append('\'').append(stringLiteral.getValue()).append('\'');
        return null;
    }

    @Override
    @Nullable
    public Void visit(@Nonnull ExpressionFragment<?> expression, @Nonnull StringBuilder context) {
        context.append(expression.getFragment());
        return null;
    }

    @Override
    @Nullable
    public Void visit(@Nonnull Field<?> field, @Nonnull StringBuilder context) {
        context.append(StreamSupport.stream(field.getParts().spliterator(), false).map(f -> "\"" + f + "\"").collect(Collectors.joining(".")));
        return null;
    }

    @Override
    @Nullable
    public Void visit(@Nonnull UserDefinedField<?> userDefinedField, @Nonnull StringBuilder context) {
        context.append(StreamSupport.stream(userDefinedField.getParts().spliterator(), false).collect(Collectors.joining(".")));
        return null;
    }
}

