/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.fluentsql.expression;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.fluentsql.FluentVisitor;
import com.apple.foundationdb.relational.api.fluentsql.expression.BooleanExpressionTrait;
import com.apple.foundationdb.relational.api.fluentsql.expression.Literal;
import com.apple.foundationdb.relational.api.metadata.DataType;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@API(value=API.Status.EXPERIMENTAL)
public final class BooleanLiteral
implements Literal<Boolean, DataType.BooleanType>,
BooleanExpressionTrait {
    @Nonnull
    private static final BooleanLiteral TRUE = new BooleanLiteral(DataType.BooleanType.notNullable(), true);
    @Nonnull
    private static final BooleanLiteral FALSE = new BooleanLiteral(DataType.BooleanType.notNullable(), false);
    private static final BooleanLiteral NULL = new BooleanLiteral(DataType.BooleanType.nullable(), null);
    @Nullable
    private final Boolean literal;
    @Nonnull
    private final DataType.BooleanType type;

    private BooleanLiteral(@Nonnull DataType.BooleanType type, @Nullable Boolean literal) {
        this.type = type;
        this.literal = literal;
    }

    @Override
    @Nullable
    public <R, C> R accept(@Nonnull FluentVisitor<R, C> visitor, @Nonnull C context) {
        return visitor.visit(this, context);
    }

    @Override
    @Nullable
    public Boolean getValue() {
        return this.literal;
    }

    @Nonnull
    public static BooleanLiteral trueLiteral() {
        return TRUE;
    }

    @Nonnull
    public static BooleanLiteral falseLiteral() {
        return FALSE;
    }

    @Nonnull
    public static BooleanLiteral nullLiteral() {
        return NULL;
    }

    @Override
    @Nonnull
    public DataType.BooleanType getType() {
        return this.type;
    }

    public String toString() {
        return this.literal == null ? "NULL" : this.literal + " : " + String.valueOf(this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BooleanLiteral that = (BooleanLiteral)o;
        return Objects.equals(this.literal, that.literal) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.literal, this.type);
    }
}

