/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.fluentsql.expression;

import com.apple.foundationdb.relational.api.fluentsql.expression.BooleanExpressionTrait;
import com.apple.foundationdb.relational.api.fluentsql.expression.BooleanFunction;
import com.apple.foundationdb.relational.api.fluentsql.expression.ComparableFunction;
import com.apple.foundationdb.relational.api.fluentsql.expression.Expression;
import com.apple.foundationdb.relational.api.fluentsql.expression.Operation;
import com.apple.foundationdb.relational.api.fluentsql.expression.ScalarExpression;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.apple.foundationdb.relational.util.Assert;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface ComparableExpressionTrait<P extends DataType, T extends Expression<P>>
extends ScalarExpression<P> {
    @Nonnull
    default public BooleanExpressionTrait isEqualTo(@Nonnull T right) {
        return new BooleanFunction(Operation.EQUAL, List.of(this, right));
    }

    @Nonnull
    default public BooleanExpressionTrait notEquals(@Nonnull T right) {
        return new BooleanFunction(Operation.NOT_EQUAL, List.of(this, right));
    }

    @Nonnull
    default public BooleanExpressionTrait greaterThan(@Nonnull T right) {
        return new BooleanFunction(Operation.GREATER_THAN, List.of(this, right));
    }

    @Nonnull
    default public BooleanExpressionTrait greaterThanOrEquals(@Nonnull T right) {
        return new BooleanFunction(Operation.GREATER_THAN_EQUALS, List.of(this, right));
    }

    @Nonnull
    default public BooleanExpressionTrait lessThan(@Nonnull T right) {
        return new BooleanFunction(Operation.LESS_THAN, List.of(this, right));
    }

    @Nonnull
    default public BooleanExpressionTrait lessThanOrEqual(@Nonnull T right) {
        return new BooleanFunction(Operation.LESS_THAN_EQUALS, List.of(this, right));
    }

    @Nonnull
    default public ComparableExpressionTrait<P, T> greatest(@Nonnull List<ComparableExpressionTrait<P, T>> arguments) {
        if (arguments.isEmpty()) {
            return this;
        }
        ImmutableList.Builder allArgumentsBuilder = ImmutableList.builder();
        allArgumentsBuilder.add(this);
        allArgumentsBuilder.addAll(arguments);
        ImmutableCollection allArguments = allArgumentsBuilder.build();
        for (ComparableExpressionTrait argument : allArguments) {
            Assert.thatUnchecked(((DataType)argument.getType()).getCode().equals((Object)((DataType)((ComparableExpressionTrait)allArguments.get(0)).getType()).getCode()), "all items must have the same type");
        }
        return new ComparableFunction(arguments.get(0).getType(), Operation.GREATEST, allArguments);
    }

    public P getType();
}

