/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.fluentsql.expression;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.fluentsql.FluentVisitor;
import com.apple.foundationdb.relational.api.fluentsql.expression.ComparableExpressionTrait;
import com.apple.foundationdb.relational.api.fluentsql.expression.Expression;
import com.apple.foundationdb.relational.api.fluentsql.expression.FunctionLike;
import com.apple.foundationdb.relational.api.fluentsql.expression.Operation;
import com.apple.foundationdb.relational.api.metadata.DataType;
import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@API(value=API.Status.EXPERIMENTAL)
public class ComparableFunction<P extends DataType, T extends Expression<P>>
implements ComparableExpressionTrait<P, T>,
FunctionLike<P> {
    @Nonnull
    private final Operation operator;
    @Nonnull
    private final ImmutableList<Expression<P>> args;
    @Nonnull
    private final P type;

    public ComparableFunction(@Nonnull P type, @Nonnull Operation operator, @Nonnull ImmutableList<ComparableExpressionTrait<P, T>> args) {
        this.type = type;
        this.operator = operator;
        this.args = ImmutableList.copyOf(args);
    }

    @Override
    @Nullable
    public <R, C> R accept(@Nonnull FluentVisitor<R, C> visitor, @Nonnull C context) {
        return visitor.visit(this, context);
    }

    @Override
    @Nonnull
    public P getType() {
        return this.type;
    }

    @Override
    @Nonnull
    public Iterable<Expression<?>> getArguments() {
        return ImmutableList.copyOf(this.args);
    }

    @Override
    @Nonnull
    public Operation getName() {
        return this.operator;
    }

    public String toString() {
        return String.valueOf((Object)this.operator) + "(" + this.args.stream().map(Object::toString).collect(Collectors.joining(",")) + ") : " + String.valueOf(this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComparableFunction that = (ComparableFunction)o;
        return this.operator == that.operator && Objects.equals(this.args, that.args) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.args, this.type});
    }
}

