/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.fluentsql.expression;

import com.apple.foundationdb.relational.api.fluentsql.expression.BooleanLiteral;
import com.apple.foundationdb.relational.api.fluentsql.expression.ExpressionFragment;
import com.apple.foundationdb.relational.api.fluentsql.expression.Field;
import com.apple.foundationdb.relational.api.fluentsql.expression.NumericLiteral;
import com.apple.foundationdb.relational.api.fluentsql.expression.ParsingFragment;
import com.apple.foundationdb.relational.api.fluentsql.expression.StringLiteral;
import com.apple.foundationdb.relational.api.fluentsql.expression.UserDefinedField;
import com.apple.foundationdb.relational.api.fluentsql.expression.details.Mixins;
import com.apple.foundationdb.relational.api.metadata.DataType;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface ExpressionFactory {
    @Nonnull
    default public BooleanLiteral literal(Boolean value) {
        if (value == null) {
            return BooleanLiteral.nullLiteral();
        }
        return value != false ? BooleanLiteral.trueLiteral() : BooleanLiteral.falseLiteral();
    }

    @Nonnull
    default public BooleanLiteral literal(boolean value) {
        return value ? BooleanLiteral.trueLiteral() : BooleanLiteral.falseLiteral();
    }

    @Nonnull
    default public NumericLiteral<Integer, DataType.IntegerType> literal(Integer value) {
        DataType.IntegerType type = value == null ? DataType.IntegerType.notNullable() : DataType.IntegerType.nullable();
        return new NumericLiteral<Integer, DataType.IntegerType>(type, value);
    }

    @Nonnull
    default public NumericLiteral<Integer, DataType.IntegerType> literal(int value) {
        return new NumericLiteral<Integer, DataType.IntegerType>(DataType.IntegerType.notNullable(), value);
    }

    @Nonnull
    default public NumericLiteral<Long, DataType.LongType> literal(@Nullable Long value) {
        DataType.LongType type = value == null ? DataType.LongType.notNullable() : DataType.LongType.nullable();
        return new NumericLiteral<Long, DataType.LongType>(type, value);
    }

    @Nonnull
    default public NumericLiteral<Long, DataType.LongType> literal(long value) {
        return new NumericLiteral<Long, DataType.LongType>(DataType.LongType.notNullable(), value);
    }

    @Nonnull
    default public NumericLiteral<Double, DataType.DoubleType> literal(@Nullable Double value) {
        DataType.DoubleType type = value == null ? DataType.DoubleType.notNullable() : DataType.DoubleType.nullable();
        return new NumericLiteral<Double, DataType.DoubleType>(type, value);
    }

    @Nonnull
    default public NumericLiteral<Double, DataType.DoubleType> literal(double value) {
        return new NumericLiteral<Double, DataType.DoubleType>(DataType.DoubleType.notNullable(), value);
    }

    @Nonnull
    default public NumericLiteral<Float, DataType.FloatType> literal(@Nullable Float value) {
        DataType.FloatType type = value == null ? DataType.FloatType.notNullable() : DataType.FloatType.nullable();
        return new NumericLiteral<Float, DataType.FloatType>(type, value);
    }

    @Nonnull
    default public NumericLiteral<Float, DataType.FloatType> literal(float value) {
        return new NumericLiteral<Float, DataType.FloatType>(DataType.FloatType.notNullable(), Float.valueOf(value));
    }

    @Nonnull
    default public StringLiteral literal(@Nullable String value) {
        DataType.StringType type = value == null ? DataType.StringType.notNullable() : DataType.StringType.nullable();
        return new StringLiteral(type, value);
    }

    default public Mixins.BooleanField field(@Nonnull DataType.BooleanType type, @Nonnull String part) {
        return this.field(type, (Iterable<String>)List.of(part)).asBoolean(type.isNullable());
    }

    @Nonnull
    default public Mixins.BooleanField field(@Nonnull DataType.BooleanType type, @Nonnull Iterable<String> parts) {
        return this.field((DataType)type, parts).asBoolean(type.isNullable());
    }

    default public Mixins.IntField field(@Nonnull DataType.IntegerType type, @Nonnull String part) {
        return this.field(type, (Iterable<String>)List.of(part));
    }

    @Nonnull
    default public Mixins.IntField field(@Nonnull DataType.IntegerType type, @Nonnull Iterable<String> parts) {
        return this.field((DataType)type, parts).asInt(type.isNullable());
    }

    default public Mixins.LongField field(@Nonnull DataType.LongType type, @Nonnull String part) {
        return this.field(type, (Iterable<String>)List.of(part)).asLong(type.isNullable());
    }

    @Nonnull
    default public Mixins.LongField field(@Nonnull DataType.LongType type, @Nonnull Iterable<String> parts) {
        return this.field((DataType)type, parts).asLong(type.isNullable());
    }

    default public Mixins.DoubleField field(@Nonnull DataType.DoubleType type, @Nonnull String part) {
        return this.field(type, (Iterable<String>)List.of(part)).asDouble(type.isNullable());
    }

    @Nonnull
    default public Mixins.DoubleField field(@Nonnull DataType.DoubleType type, @Nonnull Iterable<String> parts) {
        return this.field((DataType)type, parts).asDouble(type.isNullable());
    }

    default public Mixins.FloatField field(@Nonnull DataType.FloatType type, @Nonnull String part) {
        return this.field(type, (Iterable<String>)List.of(part)).asFloat(type.isNullable());
    }

    @Nonnull
    default public Mixins.FloatField field(@Nonnull DataType.FloatType type, @Nonnull Iterable<String> parts) {
        return this.field((DataType)type, parts).asFloat(type.isNullable());
    }

    default public Mixins.StringField field(@Nonnull DataType.StringType type, @Nonnull String part) {
        return this.field(type, (Iterable<String>)List.of(part)).asString(type.isNullable());
    }

    @Nonnull
    default public Mixins.StringField field(@Nonnull DataType.StringType type, @Nonnull Iterable<String> parts) {
        return this.field((DataType)type, parts).asString(type.isNullable());
    }

    @Nonnull
    default public <T extends DataType> Field<T> field(@Nonnull T type, @Nonnull String part) {
        return this.field(type, List.of(part));
    }

    @Nonnull
    default public <T extends DataType> Field<T> field(@Nonnull T type, @Nonnull Iterable<String> parts) {
        return new UserDefinedField<T>(type, parts);
    }

    @Nonnull
    default public Field<?> field(@Nonnull String tableName, @Nonnull String part) {
        return this.field(tableName, List.of(part));
    }

    @Nonnull
    public Field<?> field(@Nonnull String var1, @Nonnull Iterable<String> var2);

    @Nonnull
    default public ExpressionFragment<?> parseFragment(@Nonnull String fragment) {
        return new ParsingFragment<DataType.UnknownType>(DataType.UnknownType.instance(), fragment);
    }
}

