/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.relational.api.fluentsql.expression;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.relational.api.fluentsql.FluentVisitor;
import com.apple.foundationdb.relational.api.fluentsql.expression.BooleanExpressionTrait;
import com.apple.foundationdb.relational.api.metadata.DataType;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@API(value=API.Status.EXPERIMENTAL)
public class NestedBooleanExpression
implements BooleanExpressionTrait {
    @Nonnull
    private final BooleanExpressionTrait underlying;

    public NestedBooleanExpression(@Nonnull BooleanExpressionTrait value) {
        this.underlying = value;
    }

    @Nonnull
    public BooleanExpressionTrait getValue() {
        return this.underlying;
    }

    @Override
    public <R, C> R accept(@Nonnull FluentVisitor<R, C> visitor, @Nonnull C context) {
        return visitor.visit(this, context);
    }

    @Override
    public DataType getType() {
        return this.underlying.getType();
    }

    public String toString() {
        return "(" + String.valueOf(this.underlying) + ") : " + String.valueOf(this.getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedBooleanExpression that = (NestedBooleanExpression)o;
        return Objects.equals(this.underlying, that.underlying);
    }

    public int hashCode() {
        return Objects.hash(this.underlying);
    }
}

